/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.chart;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.chart.ChartData;
import com.atlassian.confluence.extra.chart.ChartDefaults;
import com.atlassian.confluence.extra.chart.ChartUtil;
import com.atlassian.confluence.extra.chart.ConfluenceChartFactory;
import com.atlassian.confluence.extra.chart.service.ChartAttachmentService;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.BlogPostLink;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.CannotGenerateThumbnailException;
import com.atlassian.confluence.pages.thumbnail.ThumbnailInfo;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.util.LocaleUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.TokenType;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(ChartMacro.class);
    private static final String CHART_PREFIX = "chart";
    private static final String AXIS_LOWER_BOUND = "axislowerbound";
    private static final String AXIS_UPPER_BOUND = "axisupperbound";
    private static final String AXIS_TICK_UNIT = "axistickunit";
    private static final String DATE_TICK_MARK_POSITION = "datetickmarkposition";
    private static final String STANDARD = "STANDARD";
    private static final String CATEGORY_LABEL_POSITION = "categorylabelposition";
    private static final String X_LABEL = "xlabel";
    private static final String Y_LABEL = "ylabel";
    private static final String OPACITY = "opacity";
    private static final String BG_COLOR = "bgcolor";
    private static final String BORDER_COLOR = "bordercolor";
    private static final String TIME_SERIES = "timeseries";
    private static final String LEGEND = "legend";
    private static final String STACKED = "stacked";
    private static final String DATA_ORIENTATION = "dataorientation";
    private static final String DATE_FORMAT = "dateformat";
    private static final String COUNTRY = "country";
    private static final String LANGUAGE = "language";
    private static final String COLUMNS = "columns";
    private static final String TABLES = "tables";
    private static final String TABLE_NUMBER = "tableNumber";
    private static final String DEFAULT_3D_CHART_OPACITY = "100";
    private static final String DEFAULT_NON_STACKED_AREA_CHART_OPACITY = "50";
    private static final String AXIS_ROTATE_TICK_LABEL = "axisrotateticklabel";
    private static final String AXIS_LABEL_ANGLE = "axislabelangle";
    private static final String PIE_SECTION_EXPLODE = "piesectionexplode";
    private static final String PIE_SECTION_LABEL = "piesectionlabel";
    private static final String SHOW_SHAPES = "showshapes";
    private static final String ORIENTATION = "orientation";
    private static final String FORGIVE = "forgive";
    private static final String SUBTITLE = "subtitle";
    private static final String TYPE = "type";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String IMAGE_FORMAT = "imageformat";
    private static final String THUMBNAIL = "thumbnail";
    private static final String DATA_DISPLAY = "datadisplay";
    private static final String DISPLAY_DATA = "displaydata";
    private static final String ALT_TEXT = "alttext";
    private static final String TITLE = "title";
    private static final String TIME_PERIOD = "timeperiod";
    private static final char[] TIME_CHARS = new char[]{'u', 's', 'm', 'h', 'd', 'M', 'y'};
    private static final String ATTACHMENT_VERSION = "attachmentversion";
    private static final String ATTACHMENT_COMMENT = "attachmentcomment";
    private static final String IMAGE_MIME_TYPE_PREFIX = "image/";
    private static final String EXT_PNG = "png";
    private static final String RANGE = "range";
    private static final String DOMAIN = "domain";
    private static final String UP_45 = "up45";
    private static final String UP_90 = "up90";
    private static final String DOWN_45 = "down45";
    private static final String DOWN_90 = "down90";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String HORIZONTAL = "horizontal";
    private static final String VERTICAL = "vertical";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String NEW = "new";
    private static final String REPLACE = "replace";
    private static final String KEEP = "keep";
    private static final String PIE_TYPE = "pie";
    private static final String BAR_TYPE = "bar";
    private static final String LINE_TYPE = "line";
    private static final String AREA_TYPE = "area";
    private static final String XYLINE_TYPE = "xyline";
    private static final String XYAREA_TYPE = "xyarea";
    private static final String XYBAR_TYPE = "xybar";
    private static final String XYSTEP_TYPE = "xystep";
    private static final String XYSTEPAREA_TYPE = "xysteparea";
    private static final String SCATTER_TYPE = "scatter";
    private static final String TIMESERIES_TYPE = "timeseries";
    private static final String GANTT_TYPE = "gantt";
    private static final String START = "start";
    private static final String MIDDLE = "middle";
    private static final String END = "end";
    private final GlobalSettingsManager settingsManager;
    private final LanguageManager languageManager;
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final ThumbnailManager thumbnailManager;
    private final WritableDownloadResourceManager downloadResourceManager;
    private final XhtmlContent xhtmlContent;
    private final LinkResolver linkResolver;
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18nBeanFactory;
    private final ChartAttachmentService chartAttachmentService;

    public ChartMacro(@ComponentImport GlobalSettingsManager settingsManager, @ComponentImport LanguageManager languageManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PermissionManager permissionManager, @ComponentImport ThumbnailManager thumbnailManager, @ComponentImport WritableDownloadResourceManager downloadResourceManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport LinkResolver linkResolver, @ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18nBeanFactory, ChartAttachmentService chartAttachmentService) {
        this.settingsManager = settingsManager;
        this.languageManager = languageManager;
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.thumbnailManager = thumbnailManager;
        this.downloadResourceManager = downloadResourceManager;
        this.xhtmlContent = xhtmlContent;
        this.linkResolver = linkResolver;
        this.localeManager = localeManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.chartAttachmentService = chartAttachmentService;
    }

    public TokenType getTokenType(Map map, String s, RenderContext renderContext) {
        return TokenType.BLOCK;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            DefaultConversionContext conversionContext = new DefaultConversionContext(renderContext);
            ArrayList errorList = new ArrayList();
            body = this.xhtmlContent.convertWikiToView(body, (ConversionContext)conversionContext, errorList);
            if (!errorList.isEmpty()) {
                for (RuntimeException runtimeException : errorList) {
                    log.error("RuntimeException while parsing wiki markup ", (Throwable)runtimeException);
                }
                throw new MacroException(this.getI18NBean().getText("confluence.extra.chart.chart.error.parseWikiToStorage"));
            }
            return this.execute((Map<String, String>)parameters, body, (ConversionContext)conversionContext);
        }
        catch (XhtmlException | MacroExecutionException | XMLStreamException e) {
            throw new MacroException(e);
        }
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Map<String, String> parameters, String chartDataHtml, ConversionContext conversionContext) throws MacroExecutionException {
        parameters = this.toLowerCase(parameters);
        try {
            String dataDisplay;
            StringBuilder chartHtmlBuilder;
            block21: {
                chartHtmlBuilder = new StringBuilder();
                String xDisplayData = this.getStringParameter(parameters, DISPLAY_DATA, FALSE);
                dataDisplay = this.getStringParameter(parameters, DATA_DISPLAY, xDisplayData);
                if (!dataDisplay.equalsIgnoreCase(FALSE) && dataDisplay.equalsIgnoreCase(BEFORE)) {
                    chartHtmlBuilder.append(chartDataHtml);
                }
                try {
                    Attachment chartImageAttachment = this.getAttachment(parameters, conversionContext, chartDataHtml);
                    if (chartImageAttachment != null) {
                        chartHtmlBuilder.append(this.getChartImageHtml(this.getBooleanParameter(parameters, THUMBNAIL, false), chartImageAttachment));
                        break block21;
                    }
                    String imageFormat = this.getStringParameter(parameters, IMAGE_FORMAT, EXT_PNG);
                    if (!this.isImageFormatSupported(imageFormat)) {
                        log.error("Invalid image format specified: {}", (Object)imageFormat);
                        throw new MacroExecutionException(this.getI18NBean().getText("confluence.extra.chart.chart.error.invalidImageFormat", Collections.singletonList(imageFormat)));
                    }
                    DownloadResourceWriter downloadResourceWriter = this.downloadResourceManager.getResourceWriter(StringUtils.defaultString((String)AuthenticatedUserThreadLocal.getUsername()), CHART_PREFIX, "." + imageFormat);
                    OutputStream outputStream = null;
                    try {
                        outputStream = downloadResourceWriter.getStreamForWriting();
                        ImageIO.write((RenderedImage)this.getChartImage(parameters, chartDataHtml), imageFormat, outputStream);
                        int width = this.getIntegerParameter(parameters, WIDTH, 300, 0, ChartDefaults.MAX_WIDTH);
                        int height = this.getIntegerParameter(parameters, HEIGHT, 300, 0, ChartDefaults.MAX_HEIGHT);
                        String altText = this.getStringParameter(parameters, ALT_TEXT, null);
                        if (altText == null) {
                            Object titleString = this.getStringParameter(parameters, TITLE, "");
                            String subTitleString = this.getStringParameter(parameters, SUBTITLE, "");
                            String xlabel = this.getStringParameter(parameters, X_LABEL, null);
                            String ylabel = this.getStringParameter(parameters, Y_LABEL, null);
                            String type = this.getStringParameter(parameters, TYPE, PIE_TYPE);
                            type = this.getI18NBean().getText("confluence.extra.chart.chart.chartType." + type);
                            if (!subTitleString.isEmpty()) {
                                titleString = (String)titleString + " " + subTitleString;
                            }
                            if (((String)titleString).isEmpty()) {
                                altText = type;
                            } else if (xlabel == null || ylabel == null) {
                                altText = this.getI18NBean().getText("confluence.extra.chart.chart.altText1", Arrays.asList(type, titleString));
                            } else if (ylabel != null) {
                                altText = this.getI18NBean().getText("confluence.extra.chart.chart.altText2", Arrays.asList(type, titleString, ylabel, xlabel));
                            }
                        }
                        chartHtmlBuilder.append(String.format("<img src=\"%s\" width=\"%d\" height=\"%d\" draggable=\"false\" alt=\"%s\" tabindex=\"0\">", downloadResourceWriter.getResourcePath() + "?delete=true", width, height, HtmlUtil.htmlEncode((String)altText)));
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)outputStream);
                    }
                }
                catch (ParseException | SeriesException parseError) {
                    chartHtmlBuilder.append(this.getErrorPanel(parseError.getMessage()));
                }
            }
            if (dataDisplay.equalsIgnoreCase(TRUE) || dataDisplay.equalsIgnoreCase(AFTER)) {
                chartHtmlBuilder.append("<br>").append(chartDataHtml);
            }
            return chartHtmlBuilder.toString();
        }
        catch (IOException ioError) {
            log.error("Unable to generate chart image", (Throwable)ioError);
            throw new MacroExecutionException((Throwable)ioError);
        }
        catch (XhtmlException | XMLStreamException xhtmlError) {
            log.error("Unable to render macro body to XHTML", xhtmlError);
            throw new MacroExecutionException(xhtmlError);
        }
        catch (CloneNotSupportedException attachmentCloneError) {
            log.error("Unable to process specified attachment", (Throwable)attachmentCloneError);
            throw new MacroExecutionException((Throwable)attachmentCloneError);
        }
        catch (CannotGenerateThumbnailException thumbnailError) {
            log.error("Unable to create thumbnail version of specified attachment", (Throwable)thumbnailError);
            throw new MacroExecutionException((Throwable)thumbnailError);
        }
    }

    private String getChartImageHtml(boolean thumbnail, Attachment chartImage) throws CannotGenerateThumbnailException {
        StringBuilder chartImageHtml = new StringBuilder("<span class=\"image-wrap\">");
        if (thumbnail && this.thumbnailManager.isThumbnailable(chartImage)) {
            this.thumbnailManager.getThumbnail(chartImage);
            ThumbnailInfo thumbnailInfo = this.thumbnailManager.getThumbnailInfo(chartImage);
            chartImageHtml.append(String.format("<a class=\"confluence-thumbnail-link\" href=\"%s%s\" draggable=\"false\"><img src=\"%s\" width=\"%d\" height=\"%d\" draggable=\"false\"></a>", this.settingsManager.getGlobalSettings().getBaseUrl(), chartImage.getDownloadPathWithoutVersion(), thumbnailInfo.getThumbnailUrlPath(), thumbnailInfo.getThumbnailWidth(), thumbnailInfo.getThumbnailHeight()));
        } else {
            chartImageHtml.append(String.format("<img src=\"%s%s\" draggable=\"false\">", this.settingsManager.getGlobalSettings().getBaseUrl(), chartImage.getDownloadPath()));
        }
        return chartImageHtml.append("</span>").toString();
    }

    BufferedImage getChartImage(Map<String, String> parameters, String chartDataHtml) throws ParseException, MacroExecutionException {
        return this.getChart(parameters, chartDataHtml).createBufferedImage(this.getIntegerParameter(parameters, WIDTH, 300, 0, ChartDefaults.MAX_WIDTH), this.getIntegerParameter(parameters, HEIGHT, 300, 0, ChartDefaults.MAX_HEIGHT));
    }

    JFreeChart getChart(Map<String, String> parameters, String rendered) throws ParseException, MacroExecutionException {
        Plot plot;
        JFreeChart chart;
        String title = parameters.get(TITLE);
        String xLabel = parameters.get(X_LABEL);
        String yLabel = parameters.get(Y_LABEL);
        String opacity = parameters.get(OPACITY);
        String bgColor = this.getStringParameter(parameters, BG_COLOR, "");
        String borderColor = parameters.get(BORDER_COLOR);
        String type = this.getStringParameter(parameters, TYPE, PIE_TYPE);
        String subTitle = this.getStringParameter(parameters, SUBTITLE, "");
        boolean legend = this.getBooleanParameter(parameters, LEGEND, true);
        boolean is3d = this.getBooleanParameter(parameters, "3d", false);
        boolean stacked = this.getBooleanParameter(parameters, STACKED, false);
        boolean timeSeries = this.getBooleanParameter(parameters, "timeseries", false);
        boolean showShapes = this.getBooleanParameter(parameters, SHOW_SHAPES, true);
        boolean tooltips = false;
        boolean urls = false;
        boolean forgive = this.getBooleanParameter(parameters, FORGIVE, true);
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        if (StringUtils.equalsIgnoreCase((CharSequence)parameters.get(ORIENTATION), (CharSequence)HORIZONTAL)) {
            plotOrientation = PlotOrientation.HORIZONTAL;
        }
        String xTableNumber = this.getStringParameter(parameters, TABLE_NUMBER, "");
        String tables = this.getStringParameter(parameters, TABLES, xTableNumber);
        String columns = this.getStringParameter(parameters, COLUMNS, "");
        String language = this.getStringParameter(parameters, LANGUAGE, "");
        String country = this.getStringParameter(parameters, COUNTRY, "");
        ChartData chartData = new ChartData(rendered, tables, columns, forgive);
        chartData.setTimePeriod(this.getStringParameter(parameters, TIME_PERIOD, "Day"));
        Collection<Locale> locales = this.getLocales(language, country);
        locales.forEach(chartData::addLocale);
        String dateFormatStr = parameters.get(DATE_FORMAT);
        if (!StringUtils.isEmpty((CharSequence)dateFormatStr)) {
            chartData.addDateFormat(dateFormatStr, language, country);
        }
        if (!StringUtils.isEmpty((CharSequence)parameters.get(DATA_ORIENTATION))) {
            chartData.setVerticalDataOrientation(VERTICAL.equalsIgnoreCase(parameters.get(DATA_ORIENTATION)));
        }
        if (PIE_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultPieDataset();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createPieChart(title, (PieDataset)dataset, legend, tooltips, urls, is3d);
        } else if (BAR_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createBarChart(title, xLabel, yLabel, (CategoryDataset)dataset, plotOrientation, legend, tooltips, urls, is3d, stacked);
            if (is3d && opacity == null) {
                opacity = DEFAULT_3D_CHART_OPACITY;
            }
        } else if (AREA_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createAreaChart(title, xLabel, yLabel, (CategoryDataset)dataset, plotOrientation, legend, tooltips, urls, stacked);
            if (!stacked && opacity == null) {
                opacity = DEFAULT_NON_STACKED_AREA_CHART_OPACITY;
            }
        } else if (LINE_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createLineChart(title, xLabel, yLabel, (CategoryDataset)dataset, plotOrientation, legend, tooltips, urls, is3d, showShapes);
        } else if (XYLINE_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createXYLineChart(title, xLabel, yLabel, (XYDataset)dataset, plotOrientation, legend, tooltips, urls);
        } else if (XYAREA_TYPE.equalsIgnoreCase(type)) {
            if (stacked) {
                dataset = new DefaultTableXYDataset();
                chartData.processData((Dataset)dataset);
                chart = ConfluenceChartFactory.createStackedXYAreaChart(title, xLabel, yLabel, (TableXYDataset)dataset, plotOrientation, legend, tooltips, urls);
            } else {
                dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
                chartData.processData((Dataset)dataset);
                chart = ConfluenceChartFactory.createXYAreaChart(title, xLabel, yLabel, (XYDataset)dataset, plotOrientation, legend, tooltips, urls);
            }
        } else if (XYBAR_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createXYBarChart(title, xLabel, timeSeries, yLabel, (IntervalXYDataset)dataset, plotOrientation, legend, tooltips, urls);
        } else if (XYSTEP_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createXYStepChart(title, xLabel, yLabel, (XYDataset)dataset, plotOrientation, legend, tooltips, urls);
        } else if (XYSTEPAREA_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createXYStepAreaChart(title, xLabel, yLabel, (XYDataset)dataset, plotOrientation, legend, tooltips, urls);
        } else if (SCATTER_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createScatterPlot(title, xLabel, yLabel, (XYDataset)dataset, plotOrientation, legend, tooltips, urls);
        } else if ("timeseries".equalsIgnoreCase(type)) {
            dataset = new TimeSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createTimeSeriesChart(title, xLabel, yLabel, (XYDataset)dataset, legend, tooltips, urls);
        } else if (GANTT_TYPE.equalsIgnoreCase(type) && ChartUtil.isVersion103Capable()) {
            chartData.setVerticalDataOrientation(true);
            dataset = new TaskSeriesCollection();
            chartData.processData((Dataset)dataset);
            chart = ConfluenceChartFactory.createGanttChart(title, xLabel, yLabel, (IntervalCategoryDataset)dataset, legend, tooltips, urls);
        } else {
            throw new MacroExecutionException("Unsupported chart type: " + type);
        }
        chart.setBackgroundPaint((Paint)(bgColor.isEmpty() ? ChartDefaults.DARK_THEME_FRIENDLY_BACKGROUND_COLOR : ChartUtil.stringToColor(bgColor)));
        TextTitle subTitleText = new TextTitle(subTitle);
        subTitleText.setPaint((Paint)ChartDefaults.DARK_THEME_FRIENDLY_COLOR);
        chart.addSubtitle((Title)subTitleText);
        if (borderColor != null) {
            chart.setBorderPaint((Paint)ChartUtil.stringToColor(borderColor));
            chart.setBorderVisible(true);
        }
        if ((plot = chart.getPlot()) instanceof PiePlot) {
            this.handlePiePlotCustomization(parameters, (PiePlot)plot);
        } else if (plot instanceof XYPlot && timeSeries) {
            ((XYPlot)plot).setDomainAxis((ValueAxis)new DateAxis(xLabel));
        }
        this.handleAxisCustomization(parameters, plot, chartData);
        this.handleOpacityCustomization(opacity, plot);
        this.handleColorCustomization(parameters, plot);
        return chart;
    }

    void handlePiePlotCustomization(Map<String, String> parameters, PiePlot plot) {
        String pieSectionLabel = this.getStringParameter(parameters, PIE_SECTION_LABEL, "%0%").replaceAll("%0%", "\\{0\\}").replaceAll("%1%", "\\{1\\}").replaceAll("%2%", "\\{2\\}");
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(pieSectionLabel));
        if (ChartUtil.isVersion103Capable()) {
            String[] explodeList;
            String pieSectionExplode = this.getStringParameter(parameters, PIE_SECTION_EXPLODE, "");
            for (String anExplodeList : explodeList = pieSectionExplode.split(",")) {
                if (StringUtils.isBlank((CharSequence)anExplodeList)) continue;
                try {
                    plot.setExplodePercent((Comparable)((Object)anExplodeList.trim()), 0.3);
                }
                catch (Exception exception) {
                    log.debug("Ignore errors");
                }
            }
        }
    }

    void handleAxisCustomization(Map<String, String> parameters, Plot plot, ChartData chartData) throws MacroExecutionException {
        if (plot instanceof CategoryPlot) {
            this.handleCategoryAxisCustomization(parameters, ((CategoryPlot)plot).getDomainAxis());
            this.handleValueAxisCustomization(parameters, ((CategoryPlot)plot).getRangeAxis(), chartData, RANGE);
        } else if (plot instanceof XYPlot) {
            this.handleValueAxisCustomization(parameters, ((XYPlot)plot).getDomainAxis(), chartData, DOMAIN);
            this.handleValueAxisCustomization(parameters, ((XYPlot)plot).getRangeAxis(), chartData, RANGE);
        }
    }

    private void handleCategoryAxisCustomization(Map<String, String> parameters, CategoryAxis axis) {
        String categoryLabelPosition = STANDARD;
        if (!StringUtils.isEmpty((CharSequence)parameters.get(CATEGORY_LABEL_POSITION))) {
            categoryLabelPosition = parameters.get(CATEGORY_LABEL_POSITION);
        }
        if (categoryLabelPosition.equalsIgnoreCase(UP_45)) {
            axis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        } else if (categoryLabelPosition.equalsIgnoreCase(UP_90)) {
            axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        } else if (categoryLabelPosition.equalsIgnoreCase(DOWN_45)) {
            axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        } else if (categoryLabelPosition.equalsIgnoreCase(DOWN_90)) {
            axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        }
    }

    private void handleValueAxisCustomization(Map<String, String> parameters, ValueAxis axis, ChartData chartData, String qualifier) throws MacroExecutionException {
        Double axisLabelAngle = this.getDoubleParameter(parameters, qualifier + AXIS_LABEL_ANGLE, null);
        if (axisLabelAngle != null) {
            axis.setLabelAngle(Math.toRadians(axisLabelAngle));
        }
        boolean axisRotateTickLabel = this.getBooleanParameter(parameters, qualifier + AXIS_ROTATE_TICK_LABEL, false);
        axis.setVerticalTickLabels(axisRotateTickLabel);
        if (axis instanceof DateAxis) {
            this.handleDateAxisCustomization(parameters, (DateAxis)axis, chartData, qualifier);
        } else {
            Double axisLowerBound = this.getDoubleParameter(parameters, qualifier + AXIS_LOWER_BOUND, null);
            Double axisUpperBound = this.getDoubleParameter(parameters, qualifier + AXIS_UPPER_BOUND, null);
            Double axisTickUnit = this.getDoubleParameter(parameters, qualifier + AXIS_TICK_UNIT, null);
            if (axisLowerBound != null) {
                axis.setLowerBound(axisLowerBound.doubleValue());
            }
            if (axisUpperBound != null) {
                axis.setUpperBound(axisUpperBound.doubleValue());
            }
            if (axisTickUnit != null && axis instanceof NumberAxis) {
                ((NumberAxis)axis).setTickUnit(new NumberTickUnit(axisTickUnit.doubleValue()));
            }
        }
    }

    private void handleDateAxisCustomization(Map<String, String> parameters, DateAxis axis, ChartData chartData, String qualifier) throws MacroExecutionException {
        axis.setDateFormatOverride(chartData.getCustomDateFormat() != null ? chartData.getCustomDateFormat() : chartData.getDateFormat(0));
        String axisLowerBound = this.getStringParameter(parameters, qualifier + AXIS_LOWER_BOUND, null);
        String axisUpperBound = this.getStringParameter(parameters, qualifier + AXIS_UPPER_BOUND, null);
        String axisTickUnit = this.getStringParameter(parameters, qualifier + AXIS_TICK_UNIT, null);
        String dateTickMarkPosition = this.getStringParameter(parameters, DATE_TICK_MARK_POSITION, null);
        if (axisLowerBound != null) {
            try {
                axis.setMinimumDate(chartData.toDate(axisLowerBound));
            }
            catch (ParseException exception) {
                throw new MacroExecutionException("Invalid date format for " + qualifier + "AxisLowerBound parameter: " + axisLowerBound);
            }
        }
        if (axisUpperBound != null) {
            try {
                axis.setMaximumDate(chartData.toDate(axisUpperBound));
            }
            catch (ParseException ignore) {
                throw new MacroExecutionException("Invalid date format for " + qualifier + "AxisUpperBound parameter: " + axisUpperBound);
            }
        }
        if (axisTickUnit != null) {
            this.setDateTick(parameters, axis, axisTickUnit);
        }
        if (dateTickMarkPosition != null) {
            if (START.equalsIgnoreCase(dateTickMarkPosition)) {
                axis.setTickMarkPosition(DateTickMarkPosition.START);
            } else if (MIDDLE.equalsIgnoreCase(dateTickMarkPosition)) {
                axis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
            } else if (END.equalsIgnoreCase(dateTickMarkPosition)) {
                axis.setTickMarkPosition(DateTickMarkPosition.END);
            }
        }
    }

    void handleOpacityCustomization(String opacity, Plot plot) throws MacroExecutionException {
        if (opacity != null) {
            try {
                int iOpacity = Integer.parseInt(opacity);
                if (iOpacity < 0 || iOpacity > 100) {
                    throw new MacroExecutionException("opacity parameter value '" + opacity + "' not between 0 and 100");
                }
                plot.setForegroundAlpha((float)iOpacity / 100.0f);
            }
            catch (NumberFormatException exception) {
                throw new MacroExecutionException("opacity parameter value '" + opacity + "' not a number between 0 and 100");
            }
        }
    }

    void handleColorCustomization(Map<String, String> parameters, Plot plot) throws MacroExecutionException {
        String colors = parameters.get("colors");
        if (colors != null) {
            String[] color = colors.split(",");
            for (int i = 0; i < color.length; ++i) {
                PiePlot piePlot;
                PieDataset pieDataset;
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).getRenderer().setSeriesPaint(i, (Paint)ChartUtil.stringToColor(color[i]));
                    continue;
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).getRenderer().setSeriesPaint(i, (Paint)ChartUtil.stringToColor(color[i]));
                    continue;
                }
                if (!(plot instanceof PiePlot) || i >= (pieDataset = (piePlot = (PiePlot)plot).getDataset()).getItemCount()) continue;
                piePlot.setSectionPaint(pieDataset.getKey(i), (Paint)ChartUtil.stringToColor(color[i]));
            }
        }
    }

    void setDateTick(Map<String, String> parameters, DateAxis axis, String tick) throws MacroExecutionException {
        int count;
        int findAt = StringUtils.indexOfAny((CharSequence)tick, (char[])TIME_CHARS);
        String value = findAt < 0 ? tick : tick.substring(0, findAt);
        try {
            count = Integer.parseInt(value.trim());
        }
        catch (NumberFormatException ignore) {
            throw new MacroExecutionException("Invalid format for date axis tick unit: " + tick);
        }
        int unit = -1;
        if (findAt >= 0) {
            if (tick.charAt(findAt) == 'y') {
                unit = 0;
            } else if (tick.charAt(findAt) == 'M') {
                unit = 1;
            } else if (tick.charAt(findAt) == 'd') {
                unit = 2;
            } else if (tick.charAt(findAt) == 'h') {
                unit = 3;
            } else if (tick.charAt(findAt) == 'm') {
                unit = 4;
            } else if (tick.charAt(findAt) == 's') {
                unit = 5;
            } else if (tick.charAt(findAt) == 'u') {
                unit = 6;
            } else {
                count = 0;
            }
        } else {
            String timePeriod = this.getStringParameter(parameters, TIME_PERIOD, "Day");
            if (timePeriod.equalsIgnoreCase("year")) {
                unit = 0;
            } else if (timePeriod.equalsIgnoreCase("quarter")) {
                unit = 1;
                count *= 3;
            } else if (timePeriod.equalsIgnoreCase("month")) {
                unit = 1;
            } else if (timePeriod.equalsIgnoreCase("day")) {
                unit = 2;
            } else if (timePeriod.equalsIgnoreCase("week")) {
                unit = 2;
                count *= 7;
            } else if (timePeriod.equalsIgnoreCase("hour")) {
                unit = 3;
            } else if (timePeriod.equalsIgnoreCase("minute")) {
                unit = 4;
            } else if (timePeriod.equalsIgnoreCase("second")) {
                unit = 5;
            } else if (timePeriod.equalsIgnoreCase("millisecond")) {
                unit = 6;
            } else {
                count = 0;
            }
        }
        if (count > 0) {
            axis.setTickUnit(new DateTickUnit(unit, count));
        }
    }

    Attachment getAttachment(Map<String, String> parameters, ConversionContext conversionContext, String chartDataHtml) throws ParseException, MacroExecutionException, XMLStreamException, XhtmlException, IOException, CloneNotSupportedException {
        Object attachmentLink = this.getStringParameter(parameters, "attachment", null);
        if (StringUtils.isNotBlank((CharSequence)attachmentLink)) {
            int indexOfCaret = ((String)attachmentLink).indexOf(94);
            if (indexOfCaret == -1) {
                attachmentLink = "^" + (String)attachmentLink;
            }
            Link aLink = this.linkResolver.createLink((RenderContext)new PageContext(conversionContext.getEntity()), (String)attachmentLink);
            String imageFormat = this.getStringParameter(parameters, IMAGE_FORMAT, EXT_PNG);
            if (aLink instanceof AttachmentLink) {
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                Attachment theAttachment = ((AttachmentLink)aLink).getAttachment();
                if (theAttachment == null) {
                    throw new MacroExecutionException(String.format("Invalid attachment link %s", attachmentLink));
                }
                String theAttachmentFileName = theAttachment.getFileName();
                String attachmentVersion = this.getStringParameter(parameters, ATTACHMENT_VERSION, NEW);
                if (KEEP.equals(attachmentVersion)) {
                    return theAttachment;
                }
                ContentEntityObject theAttachmentContentEntity = theAttachment.getContainer();
                if (NEW.equals(attachmentVersion) && !this.permissionManager.hasCreatePermission(currentUser, (Object)theAttachmentContentEntity, Attachment.class)) {
                    throw new MacroExecutionException(String.format("Export not valid. Not authorized to add %s from page: %s (%d)", theAttachmentFileName, theAttachmentContentEntity.getTitle(), theAttachmentContentEntity.getId()));
                }
                if (!(!StringUtils.equals((CharSequence)REPLACE, (CharSequence)attachmentVersion) || this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)theAttachment) && this.permissionManager.hasCreatePermission(currentUser, (Object)theAttachmentContentEntity, Attachment.class))) {
                    throw new MacroExecutionException(String.format("Export not valid. Not authorized to recreate %s from page: %s (%d)", theAttachmentFileName, theAttachmentContentEntity.getTitle(), theAttachmentContentEntity.getId()));
                }
                byte[] chartByteArray = this.getChartAsByteArray(this.getChartImage(parameters, chartDataHtml), imageFormat);
                if (this.isSameImage(theAttachment, chartByteArray)) {
                    return theAttachment;
                }
                if (REPLACE.equals(attachmentVersion)) {
                    this.attachmentManager.removeAttachmentFromServer(theAttachment);
                    theAttachment = null;
                }
                return this.chartAttachmentService.saveChartImageAsAttachment(theAttachmentContentEntity.getId(), IMAGE_MIME_TYPE_PREFIX + imageFormat, theAttachmentFileName, chartByteArray, this.getStringParameter(parameters, ATTACHMENT_COMMENT, null), theAttachment, conversionContext.getOutputType());
            }
            if (aLink instanceof UnpermittedLink) {
                throw new MacroExecutionException("Export not valid. Not authorized to view specified attachment");
            }
            if (aLink instanceof UnresolvedLink) {
                indexOfCaret = ((String)attachmentLink).indexOf(94);
                if (indexOfCaret >= 0 && indexOfCaret < ((String)attachmentLink).length() - 1) {
                    ContentEntityObject theAttachmentContentEntity = conversionContext.getEntity();
                    if (indexOfCaret > 0) {
                        Link contentEntityLink = this.linkResolver.createLink((RenderContext)new PageContext(conversionContext.getEntity()), ((String)attachmentLink).substring(0, indexOfCaret));
                        if (contentEntityLink instanceof UnpermittedLink) {
                            throw new MacroExecutionException("Export not valid. Not authorized to view specified attachment");
                        }
                        if (contentEntityLink instanceof PageLink || contentEntityLink instanceof BlogPostLink) {
                            theAttachmentContentEntity = ((AbstractPageLink)contentEntityLink).getDestinationContent();
                        }
                    }
                    return this.chartAttachmentService.saveChartImageAsAttachment(theAttachmentContentEntity.getId(), IMAGE_MIME_TYPE_PREFIX + imageFormat, ((String)attachmentLink).substring(indexOfCaret + 1), this.getChartAsByteArray(this.getChartImage(parameters, chartDataHtml), imageFormat), null, null, conversionContext.getOutputType());
                }
                throw new MacroExecutionException(String.format("Invalid attachment link %s", attachmentLink));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getChartAsByteArray(RenderedImage image, String imageFormat) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(image, imageFormat, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    Collection<Locale> getLocales(String language, String country) {
        LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
        if (!language.isEmpty() || !country.isEmpty()) {
            locales.add(new Locale(language, country));
        }
        LocaleUtils localeUtils = new LocaleUtils();
        locales.add(localeUtils.getLocale(this.settingsManager.getGlobalSettings().getGlobalDefaultLocale()));
        this.languageManager.getLanguages().forEach(lang -> locales.add(lang.getLocale()));
        return locales;
    }

    String getErrorPanel(String message) {
        return RenderUtils.blockError((String)message, (String)"");
    }

    Map<String, String> toLowerCase(Map<String, String> params) {
        HashMap<String, String> paramsWithLowerCasedKeys = new HashMap<String, String>(params.size());
        for (Map.Entry<String, String> paramValue : params.entrySet()) {
            paramsWithLowerCasedKeys.put(StringUtils.lowerCase((String)paramValue.getKey()), paramValue.getValue());
        }
        return paramsWithLowerCasedKeys;
    }

    int getIntegerParameter(Map<String, String> parameters, String param, int defaultSize, int lowerBound, int higherBound) throws MacroExecutionException {
        int result = this.getIntegerParameter(parameters, param, defaultSize);
        if (result < lowerBound) {
            result = defaultSize;
        } else if (result > higherBound) {
            result = higherBound;
        }
        return result;
    }

    Integer getIntegerParameter(Map<String, String> parameters, String param, Integer def) throws MacroExecutionException {
        String paramValue = parameters.get(param);
        Integer result = def;
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            try {
                result = Integer.valueOf(paramValue);
            }
            catch (NumberFormatException exception) {
                throw new MacroExecutionException(String.format("Invalid '%s' parameter: '%s'. It must be an integer.", param, paramValue));
            }
        }
        return result;
    }

    Double getDoubleParameter(Map<String, String> parameters, String param, Double def) throws MacroExecutionException {
        String paramValue = parameters.get(param);
        Double result = def;
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            try {
                result = Double.valueOf(paramValue);
            }
            catch (NumberFormatException exception) {
                throw new MacroExecutionException(String.format("Invalid '%s' parameter: '%s'. It must be a double value.", param, paramValue));
            }
        }
        return result;
    }

    String getStringParameter(Map<String, String> parameters, String param, String def) {
        String paramValue = parameters.get(param);
        String result = def;
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            result = paramValue.trim();
        }
        return result;
    }

    boolean getBooleanParameter(Map<String, String> parameters, String param, boolean def) {
        String paramValue = parameters.get(param);
        boolean result = paramValue != null && paramValue.equalsIgnoreCase(def ? FALSE : TRUE) ? !def : def;
        return result;
    }

    private boolean isImageFormatSupported(String imageFormat) {
        String[] writerNames;
        for (String writerFormat : writerNames = ImageIO.getWriterFormatNames()) {
            if (!writerFormat.equalsIgnoreCase(imageFormat)) continue;
            return true;
        }
        return false;
    }

    private I18NBean getI18NBean() {
        return this.i18nBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSameImage(Attachment anAttachment, byte[] chartImageBytes) throws IOException {
        InputStream attachmentInput = this.attachmentManager.getAttachmentData(anAttachment);
        try {
            boolean bl = IOUtils.contentEquals((InputStream)attachmentInput, (InputStream)new ByteArrayInputStream(chartImageBytes));
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)attachmentInput);
        }
    }
}

