/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.chart.service;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.chart.service.ChartAttachmentService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChartAttachmentServiceImpl
implements ChartAttachmentService {
    private static final String PREVIEW = "preview";
    private static final Logger log = LoggerFactory.getLogger(ChartAttachmentServiceImpl.class);
    private final TransactionalHostContextAccessor transactionalHostContextAccessor;
    private final ContentEntityManager contentEntityManager;
    private final AttachmentManager attachmentManager;

    @Autowired
    public ChartAttachmentServiceImpl(@ComponentImport TransactionalHostContextAccessor transactionalHostContextAccessor, @ComponentImport ContentEntityManager contentEntityManager, @ComponentImport AttachmentManager attachmentManager) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
        this.contentEntityManager = contentEntityManager;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public Attachment saveChartImageAsAttachment(long attachmentContainerId, String attachmentMimeType, String attachmentFileName, byte[] chartImageBytes, String comment, Attachment currentVersionOfAttachment, String outputType) {
        Attachment previousVersionOfAttachment = null != currentVersionOfAttachment && currentVersionOfAttachment.isPersistent() ? (Attachment)currentVersionOfAttachment.clone() : null;
        Attachment chartImageAttachment = null == previousVersionOfAttachment ? new Attachment() : currentVersionOfAttachment;
        chartImageAttachment.setMediaType(attachmentMimeType);
        chartImageAttachment.setVersionComment(comment);
        chartImageAttachment.setFileName(attachmentFileName);
        chartImageAttachment.setFileSize((long)chartImageBytes.length);
        if (!PREVIEW.equals(outputType)) {
            this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
                ContentEntityObject attachmentContainer = this.contentEntityManager.getById(attachmentContainerId);
                if (null == previousVersionOfAttachment) {
                    attachmentContainer.addAttachment(chartImageAttachment);
                }
                chartImageAttachment.setContainer(attachmentContainer);
                try {
                    this.attachmentManager.saveAttachment(chartImageAttachment, previousVersionOfAttachment, (InputStream)new ByteArrayInputStream(chartImageBytes));
                }
                catch (IOException e) {
                    log.error("Failed to save chart image attachment", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        return chartImageAttachment;
    }
}

