/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.periodic.event;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.content.ContentQuery;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.analytics.jobs.api.PeriodicEvent;
import com.atlassian.confluence.plugins.analytics.jobs.api.PeriodicEventSupplier;
import com.atlassian.confluence.plugins.periodic.event.ConfluenceDailyStatisticsAnalyticsEvent;
import com.atlassian.confluence.plugins.periodic.event.provider.UserDirectoryStatisticsProvider;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.status.service.systeminfo.UsageInfo;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.core.util.FileSize;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceDailyStatisticsAnalyticsEventSupplier
implements PeriodicEventSupplier {
    private final AttachmentManager attachmentManager;
    private final ClusterManager clusterManager;
    private final CommentManager commentManager;
    private final PageManager pageManager;
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private final SystemInformationService systemInformationService;
    private final LicenseService licenseService;
    private final UserChecker userChecker;
    private final UserDirectoryStatisticsProvider userDirectoryStatisticsProvider;
    private final UserAccessor userAccessor;
    private final Logger logger = LoggerFactory.getLogger(ConfluenceDailyStatisticsAnalyticsEventSupplier.class);
    private static final String USER_ADDON = "user";
    private static final String SYSTEM_ADDON = "system";
    public static final String AFC_PLUGIN_KEY = "com.addonengine.analytics";
    private final DarkFeatureManager darkFeatureManager;
    private final CustomContentManager customContentManager;

    @Autowired
    public ConfluenceDailyStatisticsAnalyticsEventSupplier(@ComponentImport AttachmentManager attachmentManager, @ComponentImport ClusterManager clusterManager, @ComponentImport CommentManager commentManager, @ComponentImport PageManager pageManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager, @ComponentImport LicenseService licenseService, @ComponentImport SystemInformationService systemInformationService, @ComponentImport UserChecker userChecker, UserDirectoryStatisticsProvider userDirectoryStatisticsProvider, @ComponentImport UserAccessor userAccessor, @ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport CustomContentManager customContentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.commentManager = Objects.requireNonNull(commentManager);
        this.pageManager = Objects.requireNonNull(pageManager);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.pluginMetadataManager = Objects.requireNonNull(pluginMetadataManager);
        this.licenseService = Objects.requireNonNull(licenseService);
        this.systemInformationService = Objects.requireNonNull(systemInformationService);
        this.userChecker = Objects.requireNonNull(userChecker);
        this.userDirectoryStatisticsProvider = Objects.requireNonNull(userDirectoryStatisticsProvider);
        this.userAccessor = userAccessor;
        this.darkFeatureManager = darkFeatureManager;
        this.customContentManager = customContentManager;
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private int propertyTableUserCount(String entityKey, String stringVal) {
        ContentQuery query = new ContentQuery("periodic.getEntitiesByKeyAndStringVal", new Object[]{entityKey, stringVal});
        Iterator iterator = this.customContentManager.findByQuery(query, 0, 1);
        return ((Long)iterator.next()).intValue();
    }

    public int colorModeandThemeUserCount(String colorMode, String theme) {
        ContentQuery query = new ContentQuery("periodic.CountEntitiesByTwoKeyAndStringValCombinations", new Object[]{"atl-theme-preferred-color-mode", colorMode, "atl-theme-preferred-" + colorMode.toLowerCase() + "-theme", theme});
        Iterator iterator = this.customContentManager.findByQuery(query, 0, 1);
        return ((Long)iterator.next()).intValue();
    }

    private int getNumberOfDarkThemeUsers() {
        try {
            Integer result = this.colorModeandThemeUserCount("DARK", "dark");
            return result != null ? result : 0;
        }
        catch (Exception e) {
            this.logger.error("Error getting number of dark theme users", (Throwable)e);
            return -1;
        }
    }

    private int getNumberOfLightThemeUsers() {
        try {
            Integer result = this.colorModeandThemeUserCount("LIGHT", "light");
            return result != null ? result : 0;
        }
        catch (Exception e) {
            this.logger.error("Error getting number of light theme users", (Throwable)e);
            return -1;
        }
    }

    private int getNumberOfOriginalThemeUsers() {
        try {
            Integer result = this.colorModeandThemeUserCount("LIGHT", "original");
            return result != null ? result : 0;
        }
        catch (Exception e) {
            this.logger.error("Error getting number of original theme users", (Throwable)e);
            return -1;
        }
    }

    private int getNumberOfMatchBrowserThemeUsers() {
        try {
            Integer result = this.propertyTableUserCount("atl-theme-preferred-color-mode", "MATCHING");
            return result != null ? result : 0;
        }
        catch (Exception e) {
            this.logger.error("Error getting number of match browser users", (Throwable)e);
            return -1;
        }
    }

    public PeriodicEvent call() {
        this.logger.debug("Gathering Confluence daily statistics...");
        long startTime = System.currentTimeMillis();
        ConfluenceDailyStatisticsAnalyticsEvent.Builder eventBuilder = ConfluenceDailyStatisticsAnalyticsEvent.builder();
        UsageInfo usageInfo = this.systemInformationService.getUsageInfo();
        ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
        try {
            this.checkInterrupted();
            long startPages = System.currentTimeMillis();
            this.pageManager.getPageStatistics().ifPresent(pageStatisticsDTO -> eventBuilder.allPages(pageStatisticsDTO.getAllPagesCount()).currentPages(pageStatisticsDTO.getCurrentPagesCount()).draftPages(pageStatisticsDTO.getDraftPagesCount()).pagesWithUnpublishedChanges(pageStatisticsDTO.getPagesWithUnpublishedChangesCount()).deletedPages(pageStatisticsDTO.getDeletedPagesCount()));
            this.logger.debug("Finished counting pages in {} ms", (Object)(System.currentTimeMillis() - startPages));
            this.checkInterrupted();
            long startBlogs = System.currentTimeMillis();
            this.pageManager.getBlogStatistics().ifPresent(blogStatisticsDTO -> eventBuilder.allBlogs(blogStatisticsDTO.getAllBlogsCount()).currentBlogs(blogStatisticsDTO.getCurrentBlogsCount()).draftBlogs(blogStatisticsDTO.getDraftBlogsCount()).blogsWithUnpublishedChanges(blogStatisticsDTO.getBlogsWithUnpublishedChangesCount()).deletedBlogs(blogStatisticsDTO.getDeletedBlogsCount()));
            this.logger.debug("Finished counting blogs in {} ms", (Object)(System.currentTimeMillis() - startBlogs));
            this.checkInterrupted();
            long startSpaces = System.currentTimeMillis();
            eventBuilder.personalSpaces(usageInfo.getPersonalSpaces()).globalSpaces(usageInfo.getGlobalSpaces());
            this.logger.debug("Finished counting spaces in {} ms", (Object)(System.currentTimeMillis() - startSpaces));
            this.checkInterrupted();
            long startComments = System.currentTimeMillis();
            eventBuilder.allComments(this.commentManager.countAllCommentVersions());
            this.logger.debug("Finished counting comments in {} ms", (Object)(System.currentTimeMillis() - startComments));
            this.checkInterrupted();
            long startAttachments = System.currentTimeMillis();
            this.attachmentManager.getAttachmentStatistics().ifPresent(attachmentStatisticsDTO -> eventBuilder.allAttachments(attachmentStatisticsDTO.getAllAttachmentsCount()).currentAttachments(attachmentStatisticsDTO.getCurrentAttachmentsCount()).allAttachmentsFileSize((long)FileSize.convertBytesToMB((long)attachmentStatisticsDTO.getAllAttachmentsFileSize())).currentAttachmentsFileSize((long)FileSize.convertBytesToMB((long)attachmentStatisticsDTO.getCurrentAttachmentsFileSize())).deletedAttachmentsFileSize((long)FileSize.convertBytesToMB((long)attachmentStatisticsDTO.getDeletedAttachmentsFileSize())));
            this.logger.debug("Finished counting attachments in {} ms", (Object)(System.currentTimeMillis() - startAttachments));
            this.checkInterrupted();
            long startUsersAndGroups = System.currentTimeMillis();
            eventBuilder.registeredUsers(this.userChecker.getNumberOfRegisteredUsers()).maxUsers(confluenceInfo.getMaxUsers()).allUsers(usageInfo.getLocalUsers()).allGroups(usageInfo.getLocalGroups()).allMemberships(usageInfo.getLocalMemberships());
            this.logger.debug("Finished counting users and groups in {} ms", (Object)(System.currentTimeMillis() - startUsersAndGroups));
            this.checkInterrupted();
            long startAddOns = System.currentTimeMillis();
            Map<String, Long> addOnCount = this.pluginAccessor.getPlugins().stream().collect(Collectors.groupingBy(plugin -> this.pluginMetadataManager.isUserInstalled(plugin) ? USER_ADDON : SYSTEM_ADDON, Collectors.counting()));
            eventBuilder.systemAddOns(addOnCount.getOrDefault(SYSTEM_ADDON, 0L)).userInstalledAddOns(addOnCount.getOrDefault(USER_ADDON, 0L));
            this.logger.debug("Finished counting addons in {} ms", (Object)(System.currentTimeMillis() - startAddOns));
            this.checkInterrupted();
            long startDirectories = System.currentTimeMillis();
            eventBuilder.userDirectory(this.userDirectoryStatisticsProvider.getUserDirectoryStatistics());
            this.logger.debug("Finished counting user directories in {} ms", (Object)(System.currentTimeMillis() - startDirectories));
            if (this.clusterManager.isClustered()) {
                eventBuilder.clusterServerNodes(this.clusterManager.getClusterInformation().getMemberCount()).uptime(this.clusterManager.getClusterUptime());
            } else {
                eventBuilder.uptime(System.currentTimeMillis() - confluenceInfo.getStartTime());
            }
            eventBuilder.isDcLicensed(this.licenseService.isLicensedForDataCenter());
            eventBuilder.afcEnabled(this.pluginAccessor.isPluginEnabled(AFC_PLUGIN_KEY));
            this.systemInformationService.getCloudPlatformMetadata().ifPresent(platformMetadata -> {
                Optional metadataContainer = this.systemInformationService.getClusteredDatabaseInformation(platformMetadata.getCloudPlatform());
                metadataContainer.ifPresent(metadata -> eventBuilder.databaseClusterNodes(metadata.getDatabaseMemberCount()));
            });
            long startCountingUnsyncedUsers = System.currentTimeMillis();
            eventBuilder.unsyncedUserCount(this.userAccessor.countUnsyncedUsers());
            this.logger.debug("Finished counting unsynced users in {} ms", (Object)(System.currentTimeMillis() - startCountingUnsyncedUsers));
            long startCountingDarkThemeUsers = System.currentTimeMillis();
            eventBuilder.darkThemeUserCount(this.getNumberOfDarkThemeUsers());
            this.logger.debug("Finished counting dark theme users in {} ms", (Object)(System.currentTimeMillis() - startCountingDarkThemeUsers));
            long startCountingLightThemeUsers = System.currentTimeMillis();
            eventBuilder.lightThemeUserCount(this.getNumberOfLightThemeUsers());
            this.logger.debug("Finished counting light theme users in {} ms", (Object)(System.currentTimeMillis() - startCountingLightThemeUsers));
            long startCountingOriginalThemeUsers = System.currentTimeMillis();
            eventBuilder.originalThemeUserCount(this.getNumberOfOriginalThemeUsers());
            this.logger.debug("Finished counting original theme users in {} ms", (Object)(System.currentTimeMillis() - startCountingOriginalThemeUsers));
            long startCountingMatchBrowserUsers = System.currentTimeMillis();
            eventBuilder.matchBrowserThemeUserCount(this.getNumberOfMatchBrowserThemeUsers());
            this.logger.debug("Finished counting match browser users in {} ms", (Object)(System.currentTimeMillis() - startCountingMatchBrowserUsers));
            long startGettingDarkThemeStateInstance = System.currentTimeMillis();
            this.darkFeatureManager.isEnabledForAllUsers("theme.switcher").ifPresent(eventBuilder::darkThemeStateInstance);
            this.logger.debug("Finished getting dark theme state instance in {} ms", (Object)(System.currentTimeMillis() - startGettingDarkThemeStateInstance));
            this.logger.debug("Finished building event in {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (InterruptedException ex) {
            this.logger.error("Thread interrupted before ConfluenceDailyStatisticsAnalyticsEvent could be fully built.");
        }
        return eventBuilder.build();
    }
}

