/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.remotepageview.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.UnlicensedSiteAccess;
import com.atlassian.confluence.plugins.remotepageview.api.service.TokenService;
import com.atlassian.confluence.plugins.remotepageview.rest.ScopesRequestCacheWrapper;
import com.atlassian.confluence.plugins.remotepageview.rest.response.TokenResponse;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Optional;

@UnlicensedSiteAccess
@Path(value="/token")
@Produces(value={"application/json;charset=UTF-8"})
public class TokenResource {
    private final TokenService tokenService;
    private final ScopesRequestCacheWrapper scopesRequestCacheWrapper;
    private final UserAccessor userAccessor;

    @Inject
    public TokenResource(TokenService tokenService, ScopesRequestCacheWrapper scopesRequestCacheWrapper, UserAccessor userAccessor) {
        this.tokenService = tokenService;
        this.scopesRequestCacheWrapper = scopesRequestCacheWrapper;
        this.userAccessor = userAccessor;
    }

    @GET
    @ScopesAllowed(requiredScope={"JSM_KB"})
    public Response generateToken(@QueryParam(value="xoauth_requestor_id") String oauthUserId, @QueryParam(value="pageId") long pageId) {
        ConfluenceUser user;
        if (this.scopesRequestCacheWrapper != null && this.scopesRequestCacheWrapper.isScopePermitted("JSM_KB") && oauthUserId != null) {
            AuthenticatedUserThreadLocal.setUser((User)this.userAccessor.getUser(oauthUserId));
        }
        if ((user = AuthenticatedUserThreadLocal.get()) == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Optional<TokenResponse> tokenResponse = this.tokenService.generateLoginTokenForUser(user, pageId);
        if (tokenResponse.isPresent()) {
            return Response.ok((Object)tokenResponse.get()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

