/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.remotepageview.servlet;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.remotepageview.api.service.RemotePageViewService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@UnrestrictedAccess
public class RemotePageViewServlet
extends HttpServlet {
    private final RemotePageViewService remotePageViewService;

    @Autowired
    public RemotePageViewServlet(RemotePageViewService remotePageViewService) {
        this.remotePageViewService = remotePageViewService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.handleRequest(httpServletRequest, httpServletResponse);
    }

    @VisibleForTesting
    void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        long pageId;
        String pageIdRequestParam = httpServletRequest.getParameter("pageId");
        if (StringUtils.isBlank((String)pageIdRequestParam)) {
            httpServletResponse.sendError(400);
            return;
        }
        try {
            pageId = Long.valueOf(pageIdRequestParam);
        }
        catch (NumberFormatException e) {
            httpServletResponse.sendError(400);
            return;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String htmlPage = this.remotePageViewService.renderPage(pageId, user);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.getWriter().write(htmlPage);
    }
}

