/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.remotepageview.servlet.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.remotepageview.api.service.TokenService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@UnrestrictedAccess
@Component(value="rpv-new-session-from-jwt-filter")
@ExportAsService
public class CreateSessionFromJwtFilter
extends AbstractHttpFilter {
    private final TokenService tokenService;

    @Autowired
    public CreateSessionFromJwtFilter(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Optional<ConfluenceUser> userFromJwtTokenOpt;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null && (userFromJwtTokenOpt = this.tokenService.getUserFromRequest((ServletRequest)httpServletRequest)).isPresent()) {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)userFromJwtTokenOpt.get());
            HttpSession httpSession = httpServletRequest.getSession();
            httpSession.setAttribute("seraph_defaultauthenticator_user", (Object)userFromJwtTokenOpt.get());
            httpSession.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

