/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dashboard.macros.dao;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.dashboard.macros.dao.ContentMacroNames;
import com.atlassian.confluence.plugins.dashboard.macros.dao.ContentMacroNamesDao;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldMappings;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.lucene.LuceneUtils;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ContentMacroNamesLuceneDao
implements ContentMacroNamesDao {
    private static final String CONTAINING_PAGE_ID = "containingPageId";
    private static final Set<String> FIELD_NAME_SET = ImmutableSet.of((Object)SearchFieldMappings.LATEST_VERSION_ID.getName(), (Object)SearchFieldMappings.HANDLE.getName(), (Object)SearchFieldMappings.MACRO_NAME.getName(), (Object)SearchFieldMappings.LAST_MODIFICATION_DATE.getName(), (Object)"containingPageId");
    private final SearchManager searchManager;
    private final ContentEntityManager contentEntityManager;

    @Autowired
    public ContentMacroNamesLuceneDao(@ComponentImport SearchManager searchManager, @ComponentImport @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager) {
        this.searchManager = searchManager;
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public List<ContentMacroNames> getContentMacroNames(Iterable<Content> contents, List<ContentMacroNames> knownMacroNamesAndComments, boolean includeComments) {
        SearchQuery query = this.getContentsQuery(contents, includeComments);
        List<ContentMacroNames> flattenedContentAndComments = this.readMacroNamesFlattened(query);
        List<ContentMacroNames> list = includeComments ? ContentMacroNames.makeCommentHierarchy(flattenedContentAndComments) : flattenedContentAndComments;
        return ContentMacroNames.merge(list, knownMacroNamesAndComments);
    }

    private SearchQuery getContentsQuery(Iterable<Content> contents, boolean includeComments) {
        SearchQuery[] queries = StreamSupport.stream(contents.spliterator(), false).map(content -> this.getContentQuery((Content)content, includeComments)).toList().toArray(new SearchQuery[0]);
        return BooleanQuery.andQuery((SearchQuery[])queries);
    }

    private SearchQuery getContentQuery(Content content, boolean includeComments) {
        long contentId = content.getId().asLong();
        ArrayList<TermQuery> queries = new ArrayList<TermQuery>(4);
        queries.add(new TermQuery("handle", Page.class.getName() + "-" + contentId));
        queries.add(new TermQuery("handle", BlogPost.class.getName() + "-" + contentId));
        queries.add(new TermQuery("handle", CustomContentEntityObject.class.getName() + "-" + contentId));
        if (includeComments) {
            queries.add(new TermQuery(CONTAINING_PAGE_ID, Long.toString(contentId)));
        }
        return BooleanQuery.orQuery((SearchQuery[])queries.toArray(new SearchQuery[0]));
    }

    private List<ContentMacroNames> readMacroNamesFlattened(SearchQuery query) {
        try {
            SearchResults searchResults = this.searchManager.search(((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)ContentSearch.builder().query(query)).startOffset(0)).limit(Integer.MAX_VALUE)).build(), FIELD_NAME_SET);
            ArrayList<ContentMacroNames> list = new ArrayList<ContentMacroNames>();
            for (SearchResult searchResult : searchResults) {
                ContentMacroNames macroNames = this.parseMacroNames(searchResult);
                if (macroNames == null) continue;
                list.add(macroNames);
            }
            return list;
        }
        catch (InvalidSearchException ex) {
            String message = String.format("Invalid search query %s; %s", query, ex.getMessage());
            throw new InfrastructureException(message, (Throwable)ex);
        }
    }

    private ContentMacroNames parseMacroNames(SearchResult searchResult) {
        HibernateHandle handle = ContentMacroNamesLuceneDao.parseHandle(searchResult);
        if (handle == null) {
            return null;
        }
        long contentId = handle.getId();
        Long commentParentContentId = handle.getClassName().equals(Comment.class.getName()) ? this.parseLong(searchResult.getField(CONTAINING_PAGE_ID)) : null;
        String contentOrCommandLastModified = searchResult.getField(SearchFieldMappings.LAST_MODIFICATION_DATE.getName());
        Set macroNames = searchResult.getFieldValues(SearchFieldMappings.MACRO_NAME.getName());
        if (!this.isLuceneRecordUpToDate(contentId, contentOrCommandLastModified)) {
            return null;
        }
        return new ContentMacroNames(contentId, commentParentContentId, macroNames, null);
    }

    private static HibernateHandle parseHandle(SearchResult searchResult) {
        String handleStr = searchResult.getField(SearchFieldMappings.HANDLE.getName());
        if (handleStr == null) {
            return null;
        }
        try {
            return new HibernateHandle(handleStr);
        }
        catch (ParseException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private Date getDbLastModified(long contentId) {
        ContentEntityObject entity = this.contentEntityManager.getById(contentId);
        return entity != null ? entity.getLastModificationDate() : null;
    }

    private boolean isLuceneRecordUpToDate(long contentId, String luceneLastModified) {
        if (luceneLastModified == null) {
            return false;
        }
        Date date = this.getDbLastModified(contentId);
        if (date == null) {
            return false;
        }
        long contentLastModified = date.getTime();
        return Objects.equals(this.luceneDateStringToMillis(luceneLastModified), contentLastModified);
    }

    private long luceneDateStringToMillis(String date) {
        return LuceneUtils.stringToDate((String)date).toInstant().toEpochMilli();
    }

    private Long parseLong(String str) {
        return str != null ? Long.valueOf(Long.parseLong(str)) : null;
    }
}

