/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dashboard.rest;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.user.User;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Path(value="/i18n")
@AnonymousSiteAccess
public class I18NResource {
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;

    @Inject
    public I18NResource(@ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory) {
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/")
    public Response postI18N(ArrayList<String> i18NKeys) {
        Locale locale = this.getCurrentLocale();
        Map<String, String> i18NProperties = this.loadI18N(i18NKeys, locale);
        return Response.ok(i18NProperties).build();
    }

    private Map<String, String> loadI18N(List<String> i18NKeys, Locale locale) {
        HashMap<String, String> i18NProperties = new HashMap<String, String>();
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(locale);
        for (String i18NKey : i18NKeys) {
            i18NProperties.put(i18NKey, i18NBean.getText(i18NKey));
        }
        return i18NProperties;
    }

    private Locale getCurrentLocale() {
        return this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get());
    }
}

