/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd;

import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStoppingEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.diagnostics.internal.ipd.IpdRegistryLogger;
import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRunner;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.util.concurrent.ThreadFactories;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterEventListeners
public class ConfluenceIpdScheduler {
    private static final Logger regularLogger = LoggerFactory.getLogger(ConfluenceIpdScheduler.class);
    private static final int DEFAULT_INTERVAL_SECONDS = 60;
    private static final int COLLECTOR_DELAY = 30;
    private static final int EMITTER_DELAY = 0;
    private static final int TERMINATION_TIMEOUT = 60;
    public static final String IPD_THREAD_NAME = "ipd-worker";
    private final ScheduledExecutorService scheduledExecutorService;
    private final IpdRegistryLogger ipdRegistryLogger;
    private final IpdRegistry ipdRegistry;
    private final IpdJobRunner ipdJobRunner;
    private final CachedIpdState cachedIpdState;

    public ConfluenceIpdScheduler(IpdRegistryLogger ipdRegistryLogger, IpdJobRunner ipdJobRunner, IpdRegistry ipdRegistry, CachedIpdState cachedIpdState) {
        this(ipdRegistryLogger, ipdJobRunner, ipdRegistry, Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)IPD_THREAD_NAME, (ThreadFactories.Type)ThreadFactories.Type.DAEMON)), cachedIpdState);
    }

    @VisibleForTesting
    ConfluenceIpdScheduler(IpdRegistryLogger ipdRegistryLogger, IpdJobRunner ipdJobRunner, IpdRegistry ipdRegistry, ScheduledExecutorService scheduledExecutorService, CachedIpdState cachedIpdState) {
        this.ipdRegistryLogger = Objects.requireNonNull(ipdRegistryLogger);
        this.ipdJobRunner = Objects.requireNonNull(ipdJobRunner);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
        this.cachedIpdState = Objects.requireNonNull(cachedIpdState);
    }

    @EventListener
    public void onApplicationStarted(ApplicationStartedEvent applicationStartedEvent) {
        this.cachedIpdState.refreshState();
        regularLogger.info("Scheduling {} with poll interval of {} seconds", (Object)"IPDMONITORING", (Object)60);
        this.scheduledExecutorService.scheduleAtFixedRate(this::ipdEmitterIteration, 0L, 60L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(this::ipdCollectorIteration, 30L, 60L, TimeUnit.SECONDS);
    }

    @EventListener
    public void onApplicationStopping(ApplicationStoppingEvent applicationStoppingEvent) {
        this.scheduledExecutorService.shutdown();
        regularLogger.info("Shutdown IPD scheduler");
        try {
            if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduledExecutorService.shutdownNow();
                if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    regularLogger.debug("Failed to terminate IPD scheduler");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduledExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    void ipdEmitterIteration() {
        try {
            this.cachedIpdState.refreshState();
            this.ipdRegistry.unregisterAllDisabledMetrics();
            this.ipdJobRunner.runJobs();
        }
        catch (Exception ex) {
            regularLogger.error("Unable to complete IPD emitting iteration.", (Throwable)ex);
        }
    }

    @VisibleForTesting
    void ipdCollectorIteration() {
        try {
            this.ipdRegistryLogger.logRegisteredMetrics();
        }
        catch (Exception ex) {
            regularLogger.error("Unable to complete IPD data logging iteration.", (Throwable)ex);
        }
    }
}

