/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.config;

import com.atlassian.diagnostics.internal.ipd.DefaultPluginIpdFactory;
import com.atlassian.diagnostics.internal.ipd.IpdMeterRegistry;
import com.atlassian.diagnostics.internal.ipd.IpdUtils;
import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.IpdLoggingService;
import com.atlassian.diagnostics.ipd.api.MeterConfigurations;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.diagnostics.ipd.api.registry.PluginIpdFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IpdConfigBeans {
    @Bean(value={"ipdMeterRegistry"})
    IpdMeterRegistry ipdMeterRegistry(MeterConfigurations meterConfigurations) {
        return new IpdMeterRegistry(meterConfigurations);
    }

    @Bean(value={"ipdRegistry"})
    IpdRegistry ipdRegistry(IpdMeterRegistry ipdMeterRegistry) {
        return ipdMeterRegistry;
    }

    @Bean(value={"meterConfigurations"})
    MeterConfigurations meterConfigurations(IpdLoggingService ipdLoggingService, CachedIpdState ipdState) {
        MeterConfigurations meterConfig = MeterConfigurations.create(options -> options.setObjectNameConstructor(key -> IpdUtils.constructObjectName((String)"com.atlassian.confluence", (MeterKey)key)).setUpdateListener(arg_0 -> ((IpdLoggingService)ipdLoggingService).logMetric(arg_0)).addEnabledCheck(meter -> ipdState.isIpdEnabled()).addEnabledCheck(meter -> !meter.isWorkInProgress() || ipdState.isWipIpdEnabled()));
        meterConfig.addMeterConfig("index.rebuild.totalTimeMillis", options -> options.setLogOnUpdate(true).setIntervalLogging(false));
        return meterConfig;
    }

    @Bean(value={"pluginIpdRegistryFactory"})
    @AvailableToPlugins
    PluginIpdFactory pluginIpdRegistryFactory(IpdMeterRegistry ipdRegistry, IpdJobRegistry ipdJobRegistry) {
        return new DefaultPluginIpdFactory(ipdRegistry, ipdJobRegistry);
    }
}

