/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.db;

import com.atlassian.confluence.internal.diagnostics.ipd.db.DatabaseConnectionStateService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class DatabaseConnectionFailuresIpdJob
implements IpdJob {
    private static final long DB_DISCONNECTED_VALUE = 1L;
    private static final long DB_CONNECTED_ZERO_VALUE = 0L;
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final CounterMeter dbFailuresCounter;

    public DatabaseConnectionFailuresIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, DatabaseConnectionStateService databaseConnectionStateService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "db.connection.failures");
        this.dbFailuresCounter = Objects.requireNonNull(ipdRegistry).counter("db.connection.failures", new MeterTag[0]);
        this.databaseConnectionStateService = Objects.requireNonNull(databaseConnectionStateService);
    }

    public void runJob() {
        DatabaseConnectionStateService.DatabaseConnectionState state = this.databaseConnectionStateService.getState();
        this.dbFailuresCounter.increment(state == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED ? 1L : 0L);
    }
}

