/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.db;

import com.atlassian.confluence.internal.diagnostics.ipd.db.DatabaseConnectionStateService;
import com.atlassian.confluence.internal.diagnostics.ipd.db.DatabasePoolDiagnosticProvider;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class DatabaseConnectionPoolIpdJob
implements IpdJob {
    private static final long NO_VALUE = -1L;
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final DatabasePoolDiagnosticProvider databasePoolDiagnosticProvider;
    private final ValueAndStatsMeterWrapper activeConnectionsMetric;
    private final ValueAndStatsMeterWrapper idleConnectionsMetric;

    public DatabaseConnectionPoolIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, DatabaseConnectionStateService databaseConnectionStateService, DatabasePoolDiagnosticProvider databasePoolDiagnosticProvider) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "db.connection.pool");
        Objects.requireNonNull(ipdRegistry);
        this.activeConnectionsMetric = ipdRegistry.valueAndStats("db.connection.pool.numActive", new MeterTag[0]);
        this.idleConnectionsMetric = ipdRegistry.valueAndStats("db.connection.pool.numIdle", new MeterTag[0]);
        this.databaseConnectionStateService = Objects.requireNonNull(databaseConnectionStateService);
        this.databasePoolDiagnosticProvider = databasePoolDiagnosticProvider;
    }

    public void runJob() {
        DatabaseConnectionStateService.DatabaseConnectionState dbState = this.databaseConnectionStateService.getState();
        DatabasePoolDiagnosticProvider.ConnectionPoolProps dbDiagnostic = this.databasePoolDiagnosticProvider.getConnectionPoolProps();
        if (dbState == DatabaseConnectionStateService.DatabaseConnectionState.DISCONNECTED || dbDiagnostic == null) {
            this.activeConnectionsMetric.updateValue(Long.valueOf(-1L));
            this.idleConnectionsMetric.updateValue(Long.valueOf(-1L));
            return;
        }
        this.activeConnectionsMetric.update(Long.valueOf(dbDiagnostic.getActiveConnections()));
        this.idleConnectionsMetric.update(Long.valueOf(dbDiagnostic.getIdleConnections()));
    }
}

