/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.db;

import com.atlassian.confluence.internal.diagnostics.ipd.db.DatabaseConnectionStateService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class DatabaseLatencyIpdJob
implements IpdJob {
    private static final Long NO_VALUE = -1L;
    private final DatabaseConnectionStateService databaseConnectionStateService;
    private final ValueAndStatsMeterWrapper latencyMetric;

    public DatabaseLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, DatabaseConnectionStateService databaseConnectionStateService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "db.connection.latency");
        this.latencyMetric = Objects.requireNonNull(ipdRegistry).valueAndStats("db.connection.latency", new MeterTag[0]);
        this.databaseConnectionStateService = Objects.requireNonNull(databaseConnectionStateService);
    }

    public void runJob() {
        Optional<Duration> latency = this.databaseConnectionStateService.getLatency();
        Long value = latency.map(Duration::toMillis).orElse(NO_VALUE);
        if (latency.isPresent()) {
            this.latencyMetric.updateStats(value);
        }
        this.latencyMetric.updateValue(value);
    }
}

