/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.filesystem;

import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.JmxCopyMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexWriterLatencyIpdJob
implements IpdJob {
    private static final Logger LOG = LoggerFactory.getLogger(IndexWriterLatencyIpdJob.class);
    private static final String COMMIT_JMX_OBJECT_NAME = "com.atlassian.confluence:type=metrics,category00=Others,category01=LuceneConnection,name=Commit";
    private static final String IPD_METRIC_NAME = "home.local.write.latency.indexwriter.statistics";
    private JmxCopyMeter metric;

    public IndexWriterLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry) {
        try {
            Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "home.local.write.latency.indexwriter");
            ObjectName originalObjectName = new ObjectName(COMMIT_JMX_OBJECT_NAME);
            this.metric = Objects.requireNonNull(ipdRegistry).statsCopy(IPD_METRIC_NAME, originalObjectName, new MeterTag[0]);
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Metric is not created. The string passed as a parameter {} does not have the right format.", (Object)COMMIT_JMX_OBJECT_NAME, (Object)e);
        }
    }

    public void runJob() {
        if (this.metric != null) {
            this.metric.update();
        }
    }
}

