/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.filesystem;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.internal.diagnostics.ipd.IpdExecutors;
import com.atlassian.confluence.internal.diagnostics.ipd.filesystem.IpdFileWriteLatencyMeter;
import com.atlassian.confluence.internal.diagnostics.ipd.filesystem.IpdLocalFileWriteLatencyMeter;
import com.atlassian.confluence.internal.diagnostics.ipd.filesystem.PathNotConfiguredException;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class LocalHomeLatencyIpdJob
implements IpdJob {
    private static final int TIMEOUT = 5;
    private static final int NUM_OF_MEASUREMENTS = 7;
    private final StatsMeter localHomeLatencyStats;
    private final ValueMeter localHomeLatencyValue;
    private final ExecutorService executorService;
    private final IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter;

    public LocalHomeLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, ApplicationProperties applicationProperties, IpdExecutors ipdExecutors) {
        this(ipdJobRegistry, ipdRegistry, ipdExecutors.createSingleTaskExecutorService("ipd-local-home"), new IpdLocalFileWriteLatencyMeter(LocalHomeLatencyIpdJob.getLocalTmpFile(applicationProperties), 7));
    }

    @VisibleForTesting
    LocalHomeLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, ExecutorService executorService, IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "home.local.write.latency.synthetic");
        Objects.requireNonNull(ipdRegistry);
        this.localHomeLatencyStats = ipdRegistry.stats("home.local.write.latency.synthetic", new MeterTag[0]);
        this.localHomeLatencyValue = ipdRegistry.value("home.local.write.latency.synthetic", new MeterTag[0]);
        this.ipdFileWriteLatencyMeter = ipdFileWriteLatencyMeter;
        this.executorService = executorService;
    }

    public void runJob() {
        Future<List> measurementsFuture = null;
        try {
            measurementsFuture = this.executorService.submit(this.ipdFileWriteLatencyMeter::makeWriteLatencyMeasurements);
            List<Long> latenciesInMicros = measurementsFuture.get(5L, TimeUnit.SECONDS).stream().map(duration -> (long)duration.getNano() / 1000L).collect(Collectors.toList());
            latenciesInMicros.forEach(latency -> this.localHomeLatencyStats.update(latency.longValue(), TimeUnit.MICROSECONDS));
            this.localHomeLatencyValue.update(IpdFileWriteLatencyMeter.getMedian(latenciesInMicros));
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.localHomeLatencyValue.update(-1L);
        }
        finally {
            if (measurementsFuture != null) {
                measurementsFuture.cancel(true);
            }
        }
    }

    private static File getLocalTmpFile(ApplicationProperties applicationProperties) {
        return applicationProperties.getLocalHomeDirectory().map(localHomePath -> localHomePath.resolve(Path.of("temp", "latency-check.tmp")).toFile()).orElseThrow(() -> new PathNotConfiguredException("Local home path is not configured"));
    }
}

