/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.filesystem;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.internal.diagnostics.ipd.IpdExecutors;
import com.atlassian.confluence.internal.diagnostics.ipd.filesystem.IpdFileWriteLatencyMeter;
import com.atlassian.confluence.internal.diagnostics.ipd.filesystem.IpdSharedFileWriteLatencyMeter;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SharedHomeLatencyIpdJob
implements IpdJob {
    private static final int TIMEOUT = 15;
    private static final int NUM_OF_MEASUREMENTS = 3;
    private final ValueAndStatsMeterWrapper sharedHomeLatency;
    final ClusterManager clusterManager;
    private final IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter;
    private final ExecutorService executorService;

    public SharedHomeLatencyIpdJob(IpdJobRegistry jobRegistry, IpdRegistry ipdRegistry, FileStore.Path sharedHome, ClusterManager clusterManager, IpdExecutors ipdExecutors) {
        this(jobRegistry, ipdRegistry, clusterManager, ipdExecutors.createSingleTaskExecutorService("ipd-shared-home"), new IpdSharedFileWriteLatencyMeter(SharedHomeLatencyIpdJob.getSharedTmpFile(sharedHome, clusterManager), 3));
    }

    @VisibleForTesting
    SharedHomeLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, ClusterManager clusterManager, ExecutorService executorService, IpdFileWriteLatencyMeter ipdFileWriteLatencyMeter) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "home.shared.write.latency");
        this.sharedHomeLatency = Objects.requireNonNull(ipdRegistry).valueAndStats("home.shared.write.latency", new MeterTag[0]);
        this.clusterManager = clusterManager;
        this.executorService = executorService;
        this.ipdFileWriteLatencyMeter = ipdFileWriteLatencyMeter;
    }

    public void runJob() {
        if (!this.clusterManager.isClustered()) {
            return;
        }
        Future<List> measurementFuture = null;
        try {
            measurementFuture = this.executorService.submit(this.ipdFileWriteLatencyMeter::makeWriteLatencyMeasurements);
            List<Long> latenciesInMillis = measurementFuture.get(15L, TimeUnit.SECONDS).stream().map(Duration::toMillis).collect(Collectors.toList());
            latenciesInMillis.forEach(arg_0 -> ((ValueAndStatsMeterWrapper)this.sharedHomeLatency).updateStats(arg_0));
            this.sharedHomeLatency.updateValue(Long.valueOf(IpdFileWriteLatencyMeter.getMedian(latenciesInMillis)));
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.sharedHomeLatency.updateValue(Long.valueOf(-1L));
        }
        finally {
            if (measurementFuture != null) {
                measurementFuture.cancel(true);
            }
        }
    }

    private static FileStore.Path getSharedTmpFile(FileStore.Path sharedHome, ClusterManager clusterManager) {
        String nodeId = Optional.ofNullable(clusterManager.getThisNodeInformation()).map(ClusterNodeInformation::getAnonymizedNodeIdentifier).orElse("node-not-in-cluster");
        return sharedHome.path(new String[]{"tmp", "latency-check-" + nodeId + ".tmp"});
    }
}

