/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdHttpMonitoringService;
import jakarta.servlet.ServletRequest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultIpdHttpMonitoringService
implements IpdHttpMonitoringService {
    private final Clock clock;
    private final Duration requestTTL;
    private final AtomicReference<Instant> lastClean;
    private final ConcurrentLinkedQueue<Instant> requestTimestampQueue;

    public DefaultIpdHttpMonitoringService(Clock clock) {
        this(clock, Duration.ofMinutes(1L), new AtomicReference<Instant>(clock.instant()), new ConcurrentLinkedQueue<Instant>());
    }

    @VisibleForTesting
    DefaultIpdHttpMonitoringService(Clock clock, Duration requestTTL, AtomicReference<Instant> lastClean, ConcurrentLinkedQueue<Instant> requestTimestampQueue) {
        this.clock = Objects.requireNonNull(clock);
        this.requestTTL = requestTTL != null ? requestTTL : Duration.ofMinutes(1L);
        this.lastClean = lastClean != null ? lastClean : new AtomicReference<Instant>(clock.instant());
        this.requestTimestampQueue = requestTimestampQueue != null ? requestTimestampQueue : new ConcurrentLinkedQueue();
    }

    @Override
    public void registerHttpRequest(ServletRequest servletRequest) {
        this.countRequest();
    }

    @Override
    public long numberOfRecentRequests(Long milliseconds) {
        return this.requestTimestampQueue.stream().filter(instant -> instant.plus((long)milliseconds, ChronoUnit.MILLIS).isAfter(this.clock.instant())).count();
    }

    private void countRequest() {
        this.requestTimestampQueue.add(this.clock.instant());
        if (this.shouldClean()) {
            this.cleanQueue();
        }
    }

    private void cleanQueue() {
        this.requestTimestampQueue.removeIf(instant -> Duration.between(this.clock.instant(), instant.plus(this.requestTTL)).isNegative());
        this.lastClean.set(this.clock.instant());
    }

    private boolean shouldClean() {
        return this.lastClean.get().plus(this.requestTTL).isBefore(this.clock.instant());
    }
}

