/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdSessionMonitoringService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;
import java.util.Optional;
import javax.management.ObjectName;

public class HttpActiveSessionIpdJob
implements IpdJob {
    private static final String SOURCE_METRIC_ACTIVE_SESSIONS = "activeSessions";
    private final IpdSessionMonitoringService service;
    private final ValueAndStatsMeterWrapper activeSessionsMetric;

    public HttpActiveSessionIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, IpdSessionMonitoringService service) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.sessions.active");
        this.activeSessionsMetric = Objects.requireNonNull(ipdRegistry).valueAndStats("http.connection.sessions.active", new MeterTag[0]);
        this.service = Objects.requireNonNull(service);
    }

    public void runJob() {
        Optional<Long> activeSessions = this.getActiveSessions();
        if (activeSessions.isPresent()) {
            this.activeSessionsMetric.update(activeSessions.get());
        } else {
            this.activeSessionsMetric.updateValue(Long.valueOf(-1L));
        }
    }

    private Optional<Long> getActiveSessions() {
        return this.service.findTomcatManagerObjectName().stream().map(objectName -> this.service.getMbeanAttribute((ObjectName)objectName, SOURCE_METRIC_ACTIVE_SESSIONS)).flatMap(Optional::stream).map(Integer.class::cast).reduce(Integer::sum).map(Long::valueOf);
    }
}

