/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.confluence.internal.diagnostics.ipd.http.DefaultHttpConnectionPoolService;
import com.atlassian.confluence.internal.diagnostics.ipd.http.HttpConnectionPoolMetric;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class HttpConnectionPoolIpdJob
implements IpdJob {
    private final DefaultHttpConnectionPoolService defaultHttpConnectionPoolService;
    private final ValueMeter numIdleMetric;
    private final ValueMeter numActiveMetric;
    private final ValueMeter numMaxMetric;

    public HttpConnectionPoolIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, DefaultHttpConnectionPoolService defaultHttpConnectionPoolService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.pool");
        Objects.requireNonNull(ipdRegistry);
        this.numActiveMetric = ipdRegistry.value("http.connection.pool.numActive", new MeterTag[0]);
        this.numIdleMetric = ipdRegistry.value("http.connection.pool.numIdle", new MeterTag[0]);
        this.numMaxMetric = ipdRegistry.value("http.connection.pool.numMax", new MeterTag[0]);
        this.defaultHttpConnectionPoolService = Objects.requireNonNull(defaultHttpConnectionPoolService);
    }

    public void runJob() {
        HttpConnectionPoolMetric metric = this.defaultHttpConnectionPoolService.getHttpPoolSizeValue();
        this.numMaxMetric.update((long)metric.getNumMax());
        this.numIdleMetric.update((long)metric.getNumIdle());
        this.numActiveMetric.update((long)metric.getNumActive());
    }
}

