/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdSessionMonitoringService;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.ConfluenceHttpSession;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.HttpSessionTracker;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.management.ObjectName;

public class HttpRecentSessionsIpdJob
implements IpdJob {
    public static final String LIST_SESSION_IDS = "listSessionIds";
    public static final int RECENTLY_ACTIVE_SESSIONS_PERIOD_IN_MINUTES = 60;
    private final HttpSessionTracker sessionTracker;
    private final IpdSessionMonitoringService service;
    private final ValueMeter recentSessionsMetric;

    public HttpRecentSessionsIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, HttpSessionTracker sessionTracker, IpdSessionMonitoringService service) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.connection.sessions.recent");
        this.recentSessionsMetric = Objects.requireNonNull(ipdRegistry).value("http.connection.sessions.recent", new MeterTag[0]);
        this.service = Objects.requireNonNull(service);
        this.sessionTracker = Objects.requireNonNull(sessionTracker);
    }

    public void runJob() {
        Instant startTime = this.getStartTime();
        Map<String, ConfluenceHttpSession> snapshot = this.sessionTracker.getSnapshot();
        long recentSessionsCount = this.getActiveSessionIds().filter(sessionId -> this.isRecentSession(snapshot, (String)sessionId, startTime)).count();
        this.recentSessionsMetric.update(recentSessionsCount);
    }

    private Instant getStartTime() {
        return Instant.now().minus(60L, ChronoUnit.MINUTES);
    }

    private Stream<String> getActiveSessionIds() {
        return this.service.findTomcatManagerObjectName().stream().map(objectName -> this.service.invokeMbeanOperation((ObjectName)objectName, LIST_SESSION_IDS, null)).flatMap(Optional::stream).map(String.class::cast).flatMap(s -> Stream.of(s.split(" "))).filter(sessionId -> !sessionId.isEmpty());
    }

    private boolean isRecentSession(Map<String, ConfluenceHttpSession> sessionSnapshot, String sessionId, Instant startTime) {
        return Optional.ofNullable(sessionSnapshot.get(sessionId)).map(session -> session.getLastAccessTime().isAfter(startTime)).orElse(false);
    }
}

