/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdHttpMonitoringService;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class HttpRequestsJob
implements IpdJob {
    private static final long METRIC_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private final IpdHttpMonitoringService ipdHttpMonitoringService;
    private final ValueAndStatsMeterWrapper requestsPerMinuteMetric;

    public HttpRequestsJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, IpdHttpMonitoringService ipdHttpMonitoringService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "http.requests");
        this.requestsPerMinuteMetric = Objects.requireNonNull(ipdRegistry).valueAndStats("http.requests", new MeterTag[0]);
        this.ipdHttpMonitoringService = Objects.requireNonNull(ipdHttpMonitoringService);
    }

    public void runJob() {
        long requestsPerMinute = this.ipdHttpMonitoringService.numberOfRecentRequests(METRIC_PERIOD);
        this.requestsPerMinuteMetric.update(Long.valueOf(requestsPerMinute));
    }
}

