/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.internal.diagnostics.ipd.http.IpdHttpMonitoringService;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.HttpSessionTracker;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

@UnrestrictedAccess
public class IpdHttpMonitoringFilter
extends HttpFilter {
    private final Supplier<IpdHttpMonitoringService> monitoringServiceRef = MemoizingComponentReference.containerComponent((String)"ipdHttpMonitoringService");
    private final Supplier<HttpSessionTracker> sessionTrackerRef = MemoizingComponentReference.containerComponent((String)"httpSessionTracker");

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ContainerManager.isContainerSetup()) {
            Optional.ofNullable(this.monitoringServiceRef.get()).ifPresent(service -> service.registerHttpRequest((ServletRequest)request));
            Optional.ofNullable(this.sessionTrackerRef.get()).ifPresent(service -> service.recordInteraction(request));
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

