/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.http.session;

import com.atlassian.confluence.internal.diagnostics.ipd.http.session.ConfluenceHttpSession;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.MutableConfluenceHttpSession;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.SessionDeletionStrategy;
import com.atlassian.confluence.internal.diagnostics.ipd.http.session.SnapshotConfluenceHttpSession;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class HttpSessionTracker {
    private final ConcurrentMap<String, MutableConfluenceHttpSession> sessionMap = new ConcurrentHashMap<String, MutableConfluenceHttpSession>();
    private final SessionDeletionStrategy deletionStrategy = new SessionDeletionStrategy();

    public void recordInteraction(HttpServletRequest httpServletRequest) {
        this.deletionStrategy.deleteOldSessions(this.sessionMap);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            String sessionId = httpSession.getId();
            MutableConfluenceHttpSession session = (MutableConfluenceHttpSession)this.sessionMap.get(sessionId);
            if (session == null) {
                MutableConfluenceHttpSession newSession = new MutableConfluenceHttpSession(sessionId, httpServletRequest.getRemoteUser());
                MutableConfluenceHttpSession previousValue = this.sessionMap.putIfAbsent(sessionId, newSession);
                session = previousValue != null ? previousValue : newSession;
            }
            session.recordInteraction(httpServletRequest.getRemoteUser());
        }
    }

    public Map<String, ConfluenceHttpSession> getSnapshot() {
        return this.sessionMap.values().stream().map(SnapshotConfluenceHttpSession::new).collect(Collectors.toMap(SnapshotConfluenceHttpSession::getId, Function.identity()));
    }
}

