/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.index;

import com.atlassian.confluence.internal.diagnostics.ipd.index.IndexQueueSizeMetric;
import com.atlassian.confluence.internal.diagnostics.ipd.index.IndexQueueSizeService;
import com.atlassian.confluence.internal.diagnostics.ipd.index.IndexQueueType;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.EnumMap;
import java.util.Objects;

public class IndexQueueSizeIpdJob
implements IpdJob {
    private final EnumMap<IndexQueueType, ValueMeter> queueSizeMetrics = new EnumMap(IndexQueueType.class);
    private final IndexQueueSizeService indexQueueSizeService;

    public IndexQueueSizeIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, IndexQueueSizeService indexQueueSizeService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "index.queue.size");
        Objects.requireNonNull(ipdRegistry);
        for (IndexQueueType indexQueueType : IndexQueueType.values()) {
            this.queueSizeMetrics.put(indexQueueType, ipdRegistry.value("index.queue.size", new MeterTag[]{MeterTag.of((String)"queueName", (String)indexQueueType.name().toLowerCase())}));
        }
        this.indexQueueSizeService = Objects.requireNonNull(indexQueueSizeService);
    }

    public void runJob() {
        IndexQueueSizeMetric metric = this.indexQueueSizeService.getIndexQueueSizeMetric();
        for (IndexQueueType indexQueueType : IndexQueueType.values()) {
            this.queueSizeMetrics.get((Object)indexQueueType).update(metric.getQueueSize(indexQueueType));
        }
    }
}

