/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.index;

import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.search.EdgeIndexQueueFlushCompleteEvent;
import com.atlassian.confluence.event.events.search.IndexQueueFlushCompleteEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.internal.diagnostics.ipd.index.IndexQueueType;
import com.atlassian.confluence.internal.search.IncrementalIndexManager;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import com.atlassian.diagnostics.ipd.api.CachedIpdState;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.event.api.EventListener;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

@RegisterEventListeners
public class IndexingQueueProcessingTimeIpdJob
implements IpdJob {
    private final EnumMap<IndexQueueType, AtomicLong> processingTime = new EnumMap(IndexQueueType.class);
    private final EnumMap<IndexQueueType, ValueAndStatsMeterWrapper> metrics = new EnumMap(IndexQueueType.class);
    private final CachedIpdState ipdState;

    public IndexingQueueProcessingTimeIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, CachedIpdState ipdState) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "index.queue.processingTime");
        Objects.requireNonNull(ipdRegistry);
        Arrays.stream(IndexQueueType.values()).forEach(indexQueueType -> {
            ValueAndStatsMeterWrapper metric = ipdRegistry.valueAndStats("index.queue.batches.processingTimeMillis", new MeterTag[]{MeterTag.of((String)"queueName", (String)indexQueueType.toString().toLowerCase())});
            this.metrics.put((IndexQueueType)((Object)indexQueueType), metric);
        });
        Arrays.stream(IndexQueueType.values()).forEach(val -> this.processingTime.put((IndexQueueType)((Object)val), new AtomicLong()));
        this.ipdState = ipdState;
    }

    @EventListener
    public void onIndexQueueFlushCompleteEvent(IndexQueueFlushCompleteEvent event) {
        if (!this.isIpdEnabled()) {
            return;
        }
        Object source = event.getSource();
        if (source instanceof IncrementalIndexManager) {
            IncrementalIndexManager manager = (IncrementalIndexManager)source;
            SearchIndex targetIndex = manager.getTargetIndex();
            long elapsedMilliseconds = event.getFlushStatistics().getElapsedMilliseconds();
            if (targetIndex == SearchIndex.CHANGE) {
                this.processingTime.get((Object)IndexQueueType.CHANGE).addAndGet(elapsedMilliseconds);
            } else if (targetIndex == SearchIndex.CONTENT) {
                this.processingTime.get((Object)IndexQueueType.MAIN).addAndGet(elapsedMilliseconds);
            }
        }
    }

    @EventListener
    public void onEdgeIndexQueueFlushCompleteEvent(EdgeIndexQueueFlushCompleteEvent event) {
        if (!this.isIpdEnabled()) {
            return;
        }
        this.processingTime.get((Object)IndexQueueType.EDGE).addAndGet(event.getFlushStatistics().getElapsedMilliseconds());
    }

    @EventListener
    public void onDarkFeatureEnabledEvent(SiteDarkFeatureEnabledEvent event) {
        this.resetMetricsWhenIpdDisabled(event);
    }

    @EventListener
    public void onSiteDarkFeatureEnabledEventInCluster(ClusterEventWrapper clusterEvent) {
        ClusterEvent event = clusterEvent.getEvent();
        if (event instanceof SiteDarkFeatureEnabledEvent) {
            SiteDarkFeatureEnabledEvent enabledEvent = (SiteDarkFeatureEnabledEvent)event;
            this.resetMetricsWhenIpdDisabled(enabledEvent);
        }
    }

    private boolean isIpdEnabled() {
        return this.ipdState.isIpdEnabled();
    }

    private void resetMetricsWhenIpdDisabled(SiteDarkFeatureEnabledEvent event) {
        if (Objects.equals(event.getFeatureKey(), "confluence.in.product.diagnostics.deny")) {
            this.processingTime.values().forEach(time -> time.set(0L));
        }
    }

    public void runJob() {
        this.processingTime.forEach((key, value) -> this.metrics.get(key).update(Long.valueOf(value.longValue())));
        this.processingTime.values().forEach(atomicLong -> atomicLong.set(0L));
    }
}

