/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.index;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.event.events.admin.ReindexFinishedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.internal.index.lucene.FullReindexManager;
import com.atlassian.confluence.search.ReIndexTask;
import com.atlassian.confluence.util.DefaultClock;
import com.atlassian.core.util.Clock;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.event.api.EventListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.Objects;

@RegisterEventListeners
public class ReIndexingDurationIpdJob
implements IpdJob {
    public static final String REINDEX_IPD_NAME = "index.rebuild.totalTimeMillis";
    private final IpdRegistry ipdRegistry;
    private final FullReindexManager fullReindexManager;
    private final Clock clock;

    public ReIndexingDurationIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, FullReindexManager fullReindexManager) {
        this(ipdJobRegistry, ipdRegistry, fullReindexManager, (Clock)new DefaultClock());
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ReIndexingDurationIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, FullReindexManager fullReindexManager, Clock clock) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, REINDEX_IPD_NAME);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.fullReindexManager = fullReindexManager;
        this.clock = clock;
    }

    public void runJob() {
    }

    @EventListener
    public void onReIndexJobFinishedEvent(ReindexFinishedEvent reIndexFinishedEvent) {
        ReIndexTask lastReindexingTask = this.fullReindexManager.getLastReindexingTask();
        Instant instant = this.clock.getCurrentDate().toInstant();
        if (lastReindexingTask != null) {
            long reindexingTimeMillis = instant.toEpochMilli() - lastReindexingTask.getStartTime();
            this.ipdRegistry.valueAndStats(REINDEX_IPD_NAME, new MeterTag[0]).update(Long.valueOf(reindexingTimeMillis));
        }
    }
}

