/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.index.items;

import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.internal.diagnostics.ipd.index.IndexQueueType;
import com.atlassian.confluence.internal.diagnostics.ipd.index.items.DefaultIndexQueueItemsService;
import com.atlassian.confluence.internal.diagnostics.ipd.index.items.IndexQueueItemType;
import com.atlassian.confluence.internal.diagnostics.ipd.index.items.ItemOperationType;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.event.api.EventListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

@RegisterEventListeners
public class IndexQueueItemsIpdJob
implements IpdJob {
    private final Map<IndexQueueType, CustomMeter<IndexQueueItemType>> addedItemsIndexQueueMetrics = new EnumMap<IndexQueueType, CustomMeter<IndexQueueItemType>>(IndexQueueType.class);
    private final Map<IndexQueueType, CustomMeter<IndexQueueItemType>> processedItemsIndexQueueMetrics = new EnumMap<IndexQueueType, CustomMeter<IndexQueueItemType>>(IndexQueueType.class);
    private final DefaultIndexQueueItemsService indexQueueItemsService;

    public IndexQueueItemsIpdJob(IpdJobRegistry ipdJobRegistry, DefaultIndexQueueItemsService indexQueueItemsService, IpdRegistry ipdRegistry) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "index.queue.items");
        Objects.requireNonNull(ipdRegistry);
        this.indexQueueItemsService = Objects.requireNonNull(indexQueueItemsService);
        this.initializeMetrics(ipdRegistry);
    }

    private void initializeMetrics(IpdRegistry ipdRegistry) {
        for (IndexQueueType indexQueueType : IndexQueueType.values()) {
            MeterTag meterTag = MeterTag.of((String)"queueName", (String)indexQueueType.name().toLowerCase());
            this.addedItemsIndexQueueMetrics.put(indexQueueType, (CustomMeter<IndexQueueItemType>)ipdRegistry.custom("index.queue.items.added", IndexQueueItemType.class, new MeterTag[]{meterTag}));
            this.processedItemsIndexQueueMetrics.put(indexQueueType, (CustomMeter<IndexQueueItemType>)ipdRegistry.custom("index.queue.items.processed", IndexQueueItemType.class, new MeterTag[]{meterTag}));
        }
    }

    @EventListener
    public void onDarkFeatureEnabledEvent(SiteDarkFeatureEnabledEvent event) {
        this.handleDarkFeatureEnabledEvent(event);
    }

    @EventListener
    public void onClusteredDarkFeatureEnabledEvent(ClusterEventWrapper clusterEvent) {
        ClusterEvent event = clusterEvent.getEvent();
        if (event instanceof SiteDarkFeatureEnabledEvent) {
            SiteDarkFeatureEnabledEvent enabledEvent = (SiteDarkFeatureEnabledEvent)event;
            this.handleDarkFeatureEnabledEvent(enabledEvent);
        }
    }

    private void handleDarkFeatureEnabledEvent(SiteDarkFeatureEnabledEvent event) {
        if (Objects.equals(event.getFeatureKey(), "confluence.in.product.diagnostics.deny")) {
            this.indexQueueItemsService.resetMetrics();
            this.resetJmxMetrics();
        }
    }

    private void resetJmxMetrics() {
        for (IndexQueueType indexQueueType : IndexQueueType.values()) {
            this.addedItemsIndexQueueMetrics.get((Object)indexQueueType).update(bean -> {
                bean.setValue(0L);
                bean.setTotal(0L);
            });
            this.processedItemsIndexQueueMetrics.get((Object)indexQueueType).update(bean -> {
                bean.setValue(0L);
                bean.setTotal(0L);
            });
        }
    }

    public void runJob() {
        for (IndexQueueType indexQueueType : IndexQueueType.values()) {
            this.updateIndexQueueMetrics(indexQueueType);
        }
    }

    private void updateIndexQueueMetrics(IndexQueueType indexQueueType) {
        long totalAddedItemsCount = this.indexQueueItemsService.getQueueItemsAdded(indexQueueType);
        long addedItemsPerInterval = this.indexQueueItemsService.calculateItemsCountPerInterval(totalAddedItemsCount, indexQueueType, ItemOperationType.ADDED);
        long totalProcessedItemsCount = this.indexQueueItemsService.getQueueItemsProcessed(indexQueueType);
        long processedItemsPerInterval = this.indexQueueItemsService.calculateItemsCountPerInterval(totalProcessedItemsCount, indexQueueType, ItemOperationType.PROCESSED);
        this.addedItemsIndexQueueMetrics.get((Object)indexQueueType).update(bean -> {
            bean.setValue(addedItemsPerInterval);
            bean.setTotal(totalAddedItemsCount);
        });
        this.processedItemsIndexQueueMetrics.get((Object)indexQueueType).update(bean -> {
            bean.setValue(processedItemsPerInterval);
            bean.setTotal(totalProcessedItemsCount);
        });
    }
}

