/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.mail.incoming;

import com.atlassian.confluence.internal.diagnostics.ipd.mail.ConnectionVerifier;
import com.atlassian.confluence.mail.Authorization;
import com.atlassian.confluence.mail.InboundMailServer;
import com.atlassian.confluence.oauth2.OAuth2Exception;
import com.atlassian.confluence.oauth2.OAuth2Service;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.oauth2.client.api.storage.token.ClientTokenEntity;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import java.util.Properties;
import java.util.function.Function;
import javax.naming.NamingException;

public class DefaultIncomingConnectionVerifier
implements ConnectionVerifier {
    private static final long MAX_TIMEOUT = 10000L;
    private final OAuth2Service oAuth2Service;
    private final Function<Properties, Session> sessionFactory;

    public DefaultIncomingConnectionVerifier(OAuth2Service oAuth2Service, Function<Properties, Session> sessionFactory) {
        this.oAuth2Service = oAuth2Service;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void verifyConnection(MailServer mailServer) throws Exception {
        try {
            this.doVerify(mailServer);
        }
        catch (Exception ex) {
            throw new MailException("Failed to connect to incoming mail server", (Throwable)ex);
        }
    }

    private void doVerify(MailServer server) throws NamingException, MailException, MessagingException, OAuth2Exception {
        InboundMailServer inboundMailServer = (InboundMailServer)server;
        try (Store store = this.getStore(inboundMailServer);){
            if (!inboundMailServer.isBasicAuth()) {
                ClientTokenEntity token = this.getToken(inboundMailServer);
                store.connect(store.getURLName().getHost(), store.getURLName().getUsername(), token.getAccessToken());
            } else {
                store.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
            }
            DefaultIncomingConnectionVerifier.verifyAccess(store);
        }
    }

    private static void verifyAccess(Store store) throws MessagingException {
        store.getFolder("INBOX").open(1);
    }

    private Store getStore(InboundMailServer inboundMailServer) throws NoSuchProviderException, OAuth2Exception, MailException, NamingException {
        Session session = this.cloneSessionWithMaxTimeout(inboundMailServer.getSession(), 10000L, this.getAuthenticationType(inboundMailServer));
        if (!inboundMailServer.isBasicAuth()) {
            ClientTokenEntity token = this.getToken(inboundMailServer);
            return session.getStore(new URLName(inboundMailServer.getMailProtocol().getProtocol(), inboundMailServer.getHostname(), Integer.parseInt(inboundMailServer.getPort()), null, inboundMailServer.getUsername(), token.getAccessToken()));
        }
        return session.getStore(inboundMailServer.getMailProtocol().getProtocol());
    }

    private ClientTokenEntity getToken(InboundMailServer mailServer) throws OAuth2Exception {
        Authorization auth = mailServer.getAuthorization();
        if (auth != null) {
            return this.oAuth2Service.getToken(auth.getTokenId());
        }
        return ClientTokenEntity.builder().build();
    }

    private Session cloneSessionWithMaxTimeout(Session session, long timeout, ConnectionVerifier.AuthenticationType type) {
        Properties props = (Properties)session.getProperties().clone();
        this.applyTimeout(timeout, type, props);
        return this.sessionFactory.apply(props);
    }
}

