/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.mail.incoming;

import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdConnectionState;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.mail.server.MailServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IpdIncomingMailServersStats {
    public static final String MAIL_INCOMING_CONNECTION_STATE = "mail.incoming.connection.state";
    public static final String SERVER_NAME = "serverName";
    private final IpdRegistry ipdRegistry;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public IpdIncomingMailServersStats(IpdRegistry ipdRegistry) {
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
    }

    public void setConnected(MailServer server) {
        this.getMeter(server).update(ipdConnectionState -> ipdConnectionState.setConnected(true));
    }

    public void setDisconnected(MailServer server) {
        this.getMeter(server).update(ipdConnectionState -> ipdConnectionState.setConnected(false));
    }

    public void remainMetersForMailServers(Collection<MailServer> servers) {
        Set serverNames = servers.stream().map(IpdIncomingMailServersStats::adjustServerName).collect(Collectors.toSet());
        this.ipdRegistry.removeIf(MAIL_INCOMING_CONNECTION_STATE, metric -> !serverNames.contains(metric.getMeterKey().getTag(SERVER_NAME)));
    }

    private CustomMeter<IpdConnectionState> getMeter(MailServer server) {
        return this.ipdRegistry.custom(MAIL_INCOMING_CONNECTION_STATE, IpdConnectionState.class, new MeterTag[]{MeterTag.of((String)SERVER_NAME, (String)IpdIncomingMailServersStats.adjustServerName(server))});
    }

    private static String adjustServerName(MailServer server) {
        return server.getName().replace(" ", "_");
    }
}

