/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.mail.outgoing;

import com.atlassian.confluence.internal.diagnostics.ipd.mail.ConnectionVerifier;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.auth.AuthenticationContextAware;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import java.util.Properties;
import java.util.function.Function;
import javax.naming.NamingException;

class DefaultSmtpConnectionVerifier
implements ConnectionVerifier {
    private final Function<Properties, Session> sessionFactory;

    public DefaultSmtpConnectionVerifier(Function<Properties, Session> sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void verifyConnection(MailServer mailServer) throws NamingException, MailException, MessagingException {
        Session sessionWithTimeout = this.cloneSessionWithMaxTimeout(mailServer.getSession(), 10000L);
        try (Transport transport = sessionWithTimeout.getTransport();){
            if (mailServer instanceof AuthenticationContextAware) {
                AuthenticationContextAware aware = (AuthenticationContextAware)mailServer;
                aware.getAuthenticationContext().connectService((Service)transport);
            } else {
                transport.connect();
            }
            if (!transport.isConnected()) {
                throw new MailException("Failed to connect to SMTP server");
            }
        }
    }

    private Session cloneSessionWithMaxTimeout(Session session, long timeout) {
        Properties props = (Properties)session.getProperties().clone();
        this.applyTimeout(timeout, ConnectionVerifier.AuthenticationType.BASIC, props);
        return this.sessionFactory.apply(props);
    }
}

