/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.mail.outgoing;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.internal.diagnostics.ipd.mail.ConnectionVerifier;
import com.atlassian.confluence.internal.diagnostics.ipd.mail.outgoing.DefaultSmtpConnectionVerifier;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdConnectionState;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import jakarta.mail.Session;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingMailServerConnectionIpdJob
implements IpdJob {
    private static final Logger LOG = LoggerFactory.getLogger(OutgoingMailServerConnectionIpdJob.class);
    private final IpdRegistry ipdRegistry;
    private final MailServerManager mailServerManager;
    private final ConnectionVerifier connectionVerifier;
    private CustomMeter<IpdConnectionState> smtpConnectionStateMeter;

    public OutgoingMailServerConnectionIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, MailServerManager mailServerManager) {
        this(ipdJobRegistry, ipdRegistry, mailServerManager, new DefaultSmtpConnectionVerifier(Session::getInstance));
    }

    @VisibleForTesting
    OutgoingMailServerConnectionIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, MailServerManager mailServerManager, ConnectionVerifier connectionVerifier) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, "mail.outgoing.connection.state");
        this.mailServerManager = mailServerManager;
        this.connectionVerifier = connectionVerifier;
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
    }

    public void runJob() {
        SMTPMailServer smtpMailServer = this.mailServerManager.getDefaultSMTPMailServer();
        if (smtpMailServer == null) {
            LOG.debug("IPD metric 'mail.outgoing.connection.state' skipped, SMTP server is not configured");
            if (this.smtpConnectionStateMeter != null) {
                this.ipdRegistry.remove(this.smtpConnectionStateMeter.getMeterKey());
                this.smtpConnectionStateMeter = null;
            }
            return;
        }
        this.smtpConnectionStateMeter = this.ipdRegistry.custom("mail.outgoing.connection.state", IpdConnectionState.class, new MeterTag[0]);
        try {
            this.connectionVerifier.verifyConnection((MailServer)smtpMailServer);
            this.smtpConnectionStateMeter.update(m -> m.setConnected(true));
        }
        catch (Exception e) {
            this.smtpConnectionStateMeter.update(m -> m.setConnected(false));
            LOG.debug("IPD metric 'mail.outgoing.connection.state' failed", (Throwable)e);
        }
    }
}

