/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.node;

import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.StatsMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdConnectionState;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class IpdInterNodesStats {
    private static final String DEST_NODE = "destNode";
    private static final String REGISTRY_PREFIX = "node";
    private final IpdRegistry ipdRegistry;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public IpdInterNodesStats(IpdRegistry ipdRegistry) {
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
    }

    public void setNodeDisconnected(String nodeId) {
        this.connectionMetric(nodeId).update(b -> b.setConnected(false));
        this.latencyMetric(nodeId).hideUntilUpdate();
    }

    public void updateNodeLatency(String nodeId, long latencyNs) {
        this.connectionMetric(nodeId).update(b -> b.setConnected(true));
        this.latencyMetric(nodeId).update(latencyNs, TimeUnit.NANOSECONDS);
    }

    public void remainMetricsForNodes(Set<String> nodesIds) {
        this.ipdRegistry.removeIf(REGISTRY_PREFIX, metric -> !nodesIds.contains(metric.getMeterKey().getTag(DEST_NODE)));
    }

    public void removeMetricsForNode(String nodeId) {
        this.ipdRegistry.removeAll(REGISTRY_PREFIX, new MeterTag[]{MeterTag.of((String)DEST_NODE, (String)nodeId)});
    }

    private StatsMeter latencyMetric(String nodeId) {
        return this.ipdRegistry.stats("node.latency", new MeterTag[]{MeterTag.of((String)DEST_NODE, (String)nodeId)});
    }

    private CustomMeter<IpdConnectionState> connectionMetric(String nodeId) {
        return this.ipdRegistry.custom("node.connection.state", IpdConnectionState.class, new MeterTag[]{MeterTag.of((String)DEST_NODE, (String)nodeId)});
    }
}

