/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.node;

import com.atlassian.confluence.internal.diagnostics.ipd.node.IpdInterNodesStats;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpdInterNodesStatsWithRemovalDelay
extends IpdInterNodesStats {
    private static final Logger LOG = LoggerFactory.getLogger(IpdInterNodesStatsWithRemovalDelay.class);
    private static final String JMX_REMOVAL_MINUTES_PROPERTY = "node.jmx.removal.minutes";
    private static final long DEFAULT_NODE_JMX_REMOVAL_MINUTES = 15L;
    private static final Duration NODE_JMX_REMOVAL_THRESHOLD = Duration.ofMinutes(IpdInterNodesStatsWithRemovalDelay.getNodeJmxRemovalMinutesProperty().orElse(15L));
    private final ConcurrentMap<String, NodeLastPing> nodesStates = new ConcurrentHashMap<String, NodeLastPing>();
    private final Clock clock;

    public IpdInterNodesStatsWithRemovalDelay(IpdRegistry ipdRegistry, Clock clock) {
        super(ipdRegistry);
        this.clock = clock;
    }

    @Override
    public void remainMetricsForNodes(Set<String> otherNodeIds) {
        HashSet nodesToRemove = new HashSet();
        this.nodesStates.forEach((nodeId, nodeLastPing) -> {
            if (otherNodeIds.contains(nodeId)) {
                return;
            }
            if (nodeLastPing.isUpForRemoval()) {
                this.removeMetricsForNode((String)nodeId);
                nodesToRemove.add(nodeId);
            } else {
                this.setNodeDisconnected((String)nodeId);
            }
        });
        nodesToRemove.forEach(this.nodesStates::remove);
        otherNodeIds.forEach(nodeId -> this.nodesStates.putIfAbsent((String)nodeId, new NodeLastPing(this.clock)));
    }

    @Override
    public void updateNodeLatency(String nodeId, long latencyNs) {
        super.updateNodeLatency(nodeId, latencyNs);
        if (this.nodesStates.containsKey(nodeId)) {
            ((NodeLastPing)this.nodesStates.get(nodeId)).updateLastPingTime();
        }
    }

    private static Optional<Long> getNodeJmxRemovalMinutesProperty() {
        try {
            long removalMinutes = Long.parseLong(System.getProperty(JMX_REMOVAL_MINUTES_PROPERTY, String.valueOf(15L)));
            return removalMinutes > 1L ? Optional.of(removalMinutes) : Optional.empty();
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid value for node.jmx.removal.minutes property. Defaulting to {} minutes.", (Object)15L, (Object)e.getCause());
            return Optional.empty();
        }
    }

    private static class NodeLastPing {
        private final AtomicReference<Instant> lastPingTime;
        private final Clock clock;

        private NodeLastPing(Clock clock) {
            this.lastPingTime = new AtomicReference<Instant>(Instant.now(clock));
            this.clock = clock;
        }

        public void updateLastPingTime() {
            this.lastPingTime.set(Instant.now(this.clock));
        }

        public boolean isUpForRemoval() {
            return this.lastPingTime.get().plus(NODE_JMX_REMOVAL_THRESHOLD).isBefore(Instant.now(this.clock));
        }
    }
}

