/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.synchrony;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.status.service.SynchronyStatusService;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdConnectionState;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronyConnectionIpdJob
implements IpdJob {
    static final String SYNCHRONY_INTEROP_PLUGIN_KEY = "com.atlassian.confluence.plugins.synchrony-interop";
    static final String SYNCHRONY_CONNECTION_STATE = "synchrony.connection.state";
    static final String SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE_DISABLE = "site-wide.shared-drafts.disable";
    static final MeterKey SYNCHRONY_CONNECTION_STATE_CUSTOM = new MeterKey("synchrony.connection.state.custom", new MeterTag[0]);
    private final IpdJobRegistry ipdJobRegistry;
    private final IpdRegistry ipdRegistry;
    private final PluginAccessor pluginAccessor;
    private final AtomicBoolean hasOutageBeenLogged = new AtomicBoolean(false);
    private final SynchronyStatusService synchronyStatusService;
    private final DarkFeaturesManager darkFeaturesManager;
    private final Logger logger;

    SynchronyConnectionIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, PluginAccessor pluginAccessor, SynchronyStatusService synchronyStatusService, DarkFeaturesManager darkFeaturesManager) {
        this(ipdJobRegistry, ipdRegistry, pluginAccessor, synchronyStatusService, darkFeaturesManager, LoggerFactory.getLogger(SynchronyConnectionIpdJob.class));
    }

    @VisibleForTesting
    SynchronyConnectionIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, PluginAccessor pluginAccessor, SynchronyStatusService synchronyStatusService, DarkFeaturesManager darkFeaturesManager, Logger logger) {
        this.ipdJobRegistry = Objects.requireNonNull(ipdJobRegistry);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.synchronyStatusService = Objects.requireNonNull(synchronyStatusService);
        this.darkFeaturesManager = Objects.requireNonNull(darkFeaturesManager);
        this.logger = Objects.requireNonNull(logger);
    }

    @PostConstruct
    void register() {
        this.ipdJobRegistry.register((IpdJob)this, SYNCHRONY_CONNECTION_STATE);
    }

    public void runJob() {
        if (this.isSharedDraftsExplicitlyDisabled()) {
            if (!this.hasOutageBeenLogged.getAndSet(true)) {
                this.logger.info("Shared drafts are disabled, skipping synchrony connection IPD job");
            }
            this.removeMetric();
            return;
        }
        if (!this.pluginAccessor.isPluginEnabled(SYNCHRONY_INTEROP_PLUGIN_KEY)) {
            if (!this.hasOutageBeenLogged.getAndSet(true)) {
                this.logger.info("Synchrony interop plugin is disabled, skipping synchrony connection IPD job");
            }
            this.removeMetric();
            return;
        }
        boolean isUp = this.synchronyStatusService.isSynchronyRunning();
        if (this.hasOutageBeenLogged.getAndSet(false)) {
            this.logger.info("Synchrony is {}", (Object)(isUp ? "Up" : "Down"));
        }
        this.getCustomMetric().update(b -> b.setConnected(isUp));
    }

    public boolean isSharedDraftsExplicitlyDisabled() {
        return this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled(SITE_WIDE_SHARED_DRAFTS_DARK_FEATURE_DISABLE);
    }

    private CustomMeter<IpdConnectionState> getCustomMetric() {
        return this.ipdRegistry.custom(SYNCHRONY_CONNECTION_STATE, IpdConnectionState.class, new MeterTag[0]);
    }

    private void removeMetric() {
        this.ipdRegistry.remove(SYNCHRONY_CONNECTION_STATE_CUSTOM);
    }
}

