/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.userdirectory;

import com.atlassian.confluence.internal.diagnostics.ipd.userdirectory.service.UserDirectoryConnectionService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.CustomMeter;
import com.atlassian.diagnostics.ipd.api.meters.custom.type.IpdConnectionState;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.util.Objects;

public class ExtUserDirectoryConnectionStateIpdJob
implements IpdJob {
    public static final String USER_DIRECTORY_CONNECTION_STATE_METER_KEY = "user.directory.connection.state";
    private final IpdRegistry ipdRegistry;
    private final UserDirectoryConnectionService userDirectoryConnectionService;

    public ExtUserDirectoryConnectionStateIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, UserDirectoryConnectionService userDirectoryConnectionService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, USER_DIRECTORY_CONNECTION_STATE_METER_KEY);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.userDirectoryConnectionService = userDirectoryConnectionService;
    }

    public void runJob() {
        long timestamp = System.currentTimeMillis();
        this.generateMeters();
        this.ipdRegistry.removeIf(USER_DIRECTORY_CONNECTION_STATE_METER_KEY, meter -> meter.lastUpdateMillis() < timestamp);
    }

    private void generateMeters() {
        this.userDirectoryConnectionService.findAllActiveExternalDirectories().forEach(directory -> {
            CustomMeter<IpdConnectionState> meter = this.getMeter((Directory)directory);
            meter.update(m -> m.setConnected(this.userDirectoryConnectionService.getConnectionState((Directory)directory)));
        });
    }

    private static MeterKey getBaseMeterKey(Directory directory) {
        return new MeterKey(USER_DIRECTORY_CONNECTION_STATE_METER_KEY, new MeterTag[]{MeterTag.of((String)"userDirName", (String)directory.getName())});
    }

    private CustomMeter<IpdConnectionState> getMeter(Directory directory) {
        MeterKey meterKey = ExtUserDirectoryConnectionStateIpdJob.getBaseMeterKey(directory);
        return this.getMeter(meterKey);
    }

    private CustomMeter<IpdConnectionState> getMeter(MeterKey key) {
        return this.ipdRegistry.custom(key.getName(), IpdConnectionState.class, key.getTags());
    }
}

