/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.diagnostics.ipd.userdirectory;

import com.atlassian.confluence.internal.diagnostics.ipd.userdirectory.service.UserDirectoryConnectionService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJob;
import com.atlassian.diagnostics.ipd.api.jobs.IpdJobRegistry;
import com.atlassian.diagnostics.ipd.api.meters.ValueAndStatsMeterWrapper;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class ExtUserDirectoryLatencyIpdJob
implements IpdJob {
    public static final String USER_DIRECTORY_LATENCY_METER_KEY = "user.directory.connection.latency";
    private final IpdRegistry ipdRegistry;
    private final UserDirectoryConnectionService userDirectoryConnectionService;

    public ExtUserDirectoryLatencyIpdJob(IpdJobRegistry ipdJobRegistry, IpdRegistry ipdRegistry, UserDirectoryConnectionService userDirectoryConnectionService) {
        Objects.requireNonNull(ipdJobRegistry).register((IpdJob)this, USER_DIRECTORY_LATENCY_METER_KEY);
        this.ipdRegistry = Objects.requireNonNull(ipdRegistry);
        this.userDirectoryConnectionService = userDirectoryConnectionService;
    }

    public void runJob() {
        long timestamp = System.currentTimeMillis();
        this.userDirectoryConnectionService.findAllActiveExternalDirectories().forEach(dir -> {
            ValueAndStatsMeterWrapper valueAndStatsMetric = this.getMeter((Directory)dir);
            Optional<Duration> latency = this.userDirectoryConnectionService.getLatency((Directory)dir);
            long value = latency.map(Duration::toMillis).orElse(-1L);
            if (latency.isPresent()) {
                valueAndStatsMetric.update(Long.valueOf(value));
            } else {
                valueAndStatsMetric.updateValue(Long.valueOf(value));
            }
        });
        this.ipdRegistry.removeIf(USER_DIRECTORY_LATENCY_METER_KEY, meter -> meter.lastUpdateMillis() < timestamp);
    }

    private ValueAndStatsMeterWrapper getMeter(Directory directory) {
        return this.ipdRegistry.valueAndStats(USER_DIRECTORY_LATENCY_METER_KEY, new MeterTag[]{MeterTag.of((String)"userDirName", (String)directory.getName())});
    }
}

