/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.previews.jwt;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.previews.jwt.JwtTokenService;
import com.atlassian.confluence.util.Cleanup;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class JwtInjectUserFilter
implements Filter {
    private final JwtTokenService jwtTokenService;

    @Autowired
    public JwtInjectUserFilter(JwtTokenService jwtTokenService) {
        this.jwtTokenService = jwtTokenService;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try (Cleanup ignore = this.jwtTokenService.asUserFromRequest(request);){
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

