/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.previews.jwt;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.plugins.previews.jwt.JwtTokenService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class TokenAuthWhitelistFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthWhitelistFilter.class);
    private final JwtTokenService jwtTokenService;

    @Autowired
    public TokenAuthWhitelistFilter(JwtTokenService jwtTokenService) {
        this.jwtTokenService = jwtTokenService;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.jwtTokenService.isSignedByPreviewsPlugin(request)) {
            this.whitelistRequest(request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void whitelistRequest(HttpServletRequest request) {
        log.info("TokenAuthWhitelistFilter: whitelisting request {}", (Object)TokenAuthWhitelistFilter.sanitizeStr(request.getRequestURI()));
        request.setAttribute("TokenAuthWhitelistOK", (Object)Boolean.TRUE);
    }

    private static String sanitizeStr(String str) {
        return str.replaceAll("[\r\n]", "");
    }
}

