/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.previews.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.plugins.previews.api.CompanionActionBean;
import com.atlassian.confluence.plugins.previews.api.CompanionActionEvent;
import com.atlassian.confluence.plugins.previews.jwt.JwtLogHitService;
import com.atlassian.confluence.plugins.previews.model.AttachmentUsageStatusModel;
import com.atlassian.confluence.plugins.previews.model.CompanionAttachmentModel;
import com.atlassian.confluence.plugins.previews.model.CompanionLinkModel;
import com.atlassian.confluence.plugins.previews.model.TempLinksModel;
import com.atlassian.confluence.plugins.previews.service.TempLinksService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/templinksresource")
public class TempLinksResource {
    private final Logger LOGGER = LoggerFactory.getLogger(TempLinksResource.class);
    private final TempLinksService tempLinksService;
    private final JwtLogHitService jwtLogHitService;
    private final HttpContext httpContext;
    private final UserManager userManager;
    private final EventPublisher eventPublisher;

    @Inject
    public TempLinksResource(TempLinksService tempLinksService, JwtLogHitService jwtLogHitService, @ComponentImport HttpContext httpContext, @ComponentImport UserManager userManager, @ComponentImport EventPublisher eventPublisher) {
        this.tempLinksService = tempLinksService;
        this.jwtLogHitService = jwtLogHitService;
        this.httpContext = httpContext;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Path(value="/attachmenturl")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    @ScopesAllowed(requiredScope={"READ"})
    public TempLinksModel getMessage(@QueryParam(value="attachmentId") long attachmentId) {
        Optional<TempLinksModel> model = this.tempLinksService.resolveLinks(attachmentId);
        WebApplicationException ex = new WebApplicationException(Response.Status.NOT_FOUND);
        return model.orElseThrow(() -> ex);
    }

    @GET
    @Path(value="/companion/attachment")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public CompanionAttachmentModel getAttachmentMeta(@QueryParam(value="attachmentId") long attachmentId) {
        Optional<CompanionAttachmentModel> model = this.tempLinksService.resolveCompanionAttachmentMeta(attachmentId);
        this.jwtLogHitService.logHit((ServletRequest)this.httpContext.getActiveRequest());
        WebApplicationException ex = new WebApplicationException(Response.Status.NOT_FOUND);
        return model.orElseThrow(() -> ex);
    }

    @GET
    @Path(value="/companion/attachment-usage-status")
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public AttachmentUsageStatusModel getAttachmentUsageStatus(@QueryParam(value="jwtId") String jwtId) {
        UserKey userKey = Objects.requireNonNull(this.userManager.getRemoteUserKey());
        try {
            Optional<Boolean> retVal = this.jwtLogHitService.isInCache(userKey.getStringValue(), jwtId);
            return new AttachmentUsageStatusModel(retVal.orElse(Boolean.FALSE));
        }
        catch (RuntimeException ex) {
            this.LOGGER.error("TempLinksResource.getAttachmentUsageStatus: error checking cache", (Throwable)ex);
            return new AttachmentUsageStatusModel(Boolean.FALSE);
        }
    }

    @GET
    @Path(value="/companion/link")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    @ScopesAllowed(requiredScope={"READ"})
    public CompanionLinkModel getCompanionLink(@QueryParam(value="attachmentId") long attachmentId) throws URISyntaxException {
        Optional<CompanionLinkModel> model = this.tempLinksService.resolveCompanionLink(attachmentId);
        WebApplicationException ex = new WebApplicationException(Response.Status.NOT_FOUND);
        return model.orElseThrow(() -> ex);
    }

    @POST
    @Path(value="/companion/{attachmentId}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response discardCallback(@PathParam(value="attachmentId") long attachmentId, CompanionActionBean companionActionBean) {
        this.eventPublisher.publish((Object)new CompanionActionEvent((Object)attachmentId, AuthenticatedUserThreadLocal.get(), attachmentId, companionActionBean));
        String action = companionActionBean != null ? companionActionBean.getAction().name() : "unknown";
        this.LOGGER.debug("Published CompanionActionEvent event with attachment id {{}} and action {{}}", (Object)attachmentId, (Object)action);
        return Response.ok().build();
    }
}

