/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.confluence_kb_space_blueprint.rest;

import com.atlassian.confluence.search.v2.DecoratorSearchBuilder;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.Index;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.SearchIndex;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SearchWithHighlight
implements ISearch {
    HightlightParams hightlightParams = new HightlightParams(){

        public String getPreTag() {
            return "@@@hl@@@";
        }

        public String getPostTag() {
            return "@@@endhl@@@";
        }

        public String getEncoder() {
            return "none";
        }

        public SearchQuery getQuery() {
            return super.getQuery();
        }
    };
    private final ISearch search;
    private final boolean highlight;

    public SearchWithHighlight(ISearch search, boolean highlight) {
        this.search = search;
        this.highlight = highlight;
    }

    public @NonNull SearchQuery getQuery() {
        return this.search.getQuery();
    }

    public SearchSort getSort() {
        return this.search.getSort();
    }

    public int getStartOffset() {
        return this.search.getStartOffset();
    }

    public int getLimit() {
        return this.search.getLimit();
    }

    public EnumSet<SearchIndex> getSearchIndexes() {
        return this.search.getSearchIndexes();
    }

    public List<Index> getIndices() {
        return this.search.getIndices();
    }

    public Optional<HightlightParams> getHighlight() {
        if (this.highlight) {
            return Optional.of(this.hightlightParams);
        }
        return Optional.empty();
    }

    public ISearch.Builder<SearchWithHighlight> toBuilder() {
        return new DecoratorSearchBuilder(this.search.toBuilder(), s -> new SearchWithHighlight((ISearch)s, this.highlight));
    }
}

