/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.files.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.files.api.services.ConfluenceFileService;
import com.atlassian.confluence.plugins.files.entities.ConfluenceFileEntity;
import com.atlassian.confluence.plugins.files.entities.FileVersionSummaryEntity;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

@AnonymousSiteAccess
@ReadOnlyAccessAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/files")
public class ConfluenceFileResource {
    private final ConfluenceFileService fileService;

    @Inject
    public ConfluenceFileResource(ConfluenceFileService fileService) {
        this.fileService = fileService;
    }

    @GET
    @Path(value="/content/{contentId}/byAttachmentId")
    @ScopesAllowed(requiredScope={"READ"})
    public ConfluenceFileEntity getConfluenceFile(@PathParam(value="contentId") long contentId, @QueryParam(value="attachmentId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion) throws ServiceException {
        return this.fileService.getFileById(attachmentId, attachmentVersion);
    }

    @GET
    @Path(value="/content/{contentId}")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<ConfluenceFileEntity> getConfluenceFiles(@PathParam(value="contentId") long contentId, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return RestList.newRestList(this.fileService.getFiles(contentId, (PageRequest)pageRequest)).pageRequest((PageRequest)pageRequest).build();
    }

    @POST
    @Path(value="/content/{contentId}/byAttachmentIds")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"WRITE"})
    public PageResponse<ConfluenceFileEntity> getConfluenceFiles(@PathParam(value="contentId") long contentId, AttachmentIdsWrapper attachmentIdsWrapper) throws ServiceException {
        List<Long> attachmentIds = attachmentIdsWrapper.getAttachmentIds();
        return RestList.newRestList(this.fileService.getFilesByIds(attachmentIds)).build();
    }

    @POST
    @Path(value="/content/{contentId}/minusAttachmentIds")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<ConfluenceFileEntity> getConfluenceFilesMinusAttachmentIds(@PathParam(value="contentId") long contentId, AttachmentIdsWrapper attachmentIdsWrapper, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        List<Long> attachmentIds = attachmentIdsWrapper.getAttachmentIds();
        return RestList.newRestList(this.fileService.getFilesMinusAttachmentId(contentId, attachmentIds, (PageRequest)restPageRequest)).build();
    }

    @GET
    @Path(value="/content/{contentId}/commentCount")
    @ScopesAllowed(requiredScope={"READ"})
    public int getUnresolvedCommentCountPathParam(@PathParam(value="contentId") long contentId, @QueryParam(value="attachmentId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion) throws ServiceException {
        return this.fileService.getUnresolvedCommentCountByAttachmentId(attachmentId, attachmentVersion);
    }

    @GET
    @Path(value="/{fileId}/versions")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<FileVersionSummaryEntity> getVersionSummaries(@PathParam(value="fileId") long attachmentId, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return RestList.newRestList(this.fileService.getVersionSummaries(attachmentId, (PageRequest)pageRequest)).pageRequest((PageRequest)pageRequest).build();
    }

    public static class AttachmentIdsWrapper {
        private List<Long> attachmentIds;

        public List<Long> getAttachmentIds() {
            return this.attachmentIds;
        }

        public void setAttachmentIds(List<Long> attachmentIds) {
            this.attachmentIds = attachmentIds;
        }
    }
}

