/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.files.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.files.api.FileComment;
import com.atlassian.confluence.plugins.files.api.services.FileCommentService;
import com.atlassian.confluence.plugins.files.entities.FileCommentInput;
import com.atlassian.confluence.plugins.files.filters.ReadOnlyAccessFilterDynamicBinding;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@ReadOnlyAccessFilterDynamicBinding
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/files/{fileId}/comments")
public class FileCommentResource {
    private final FileCommentService commentService;

    @Inject
    public FileCommentResource(FileCommentService commentService) throws ServiceException {
        this.commentService = commentService;
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public FileComment createFileComment(@PathParam(value="fileId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion, FileCommentInput commentInput) throws ServiceException {
        return this.commentService.createComment(attachmentId, attachmentVersion, commentInput);
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<FileComment> getFileComments(@PathParam(value="fileId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse<FileComment> response = this.commentService.getComments(attachmentId, attachmentVersion, (PageRequest)pageRequest);
        return RestList.newRestList(response).pageRequest((PageRequest)pageRequest).build();
    }

    @GET
    @Path(value="/{commentId}")
    @ScopesAllowed(requiredScope={"READ"})
    public FileComment getFileCommentById(@PathParam(value="fileId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion, @PathParam(value="commentId") long commentId) throws ServiceException {
        return this.commentService.getCommentById(attachmentId, attachmentVersion, commentId);
    }

    @PUT
    @Path(value="/{commentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public FileComment updateFileComment(@PathParam(value="fileId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion, @PathParam(value="commentId") long commentId, FileCommentInput commentInput) throws ServiceException {
        return this.commentService.updateComment(attachmentId, attachmentVersion, commentId, commentInput);
    }

    @DELETE
    @Path(value="/{commentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public void deleteFileComment(@PathParam(value="fileId") long attachmentId, @QueryParam(value="attachmentVersion") @DefaultValue(value="0") int attachmentVersion, @PathParam(value="commentId") long commentId) throws ServiceException {
        this.commentService.deleteComment(attachmentId, attachmentVersion, commentId);
    }
}

