/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.application.jira;

import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.ThreeLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.application.jira.JiraApplicationTypeImpl;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.core.manifest.AppLinksManifestDownloader;
import com.atlassian.applinks.core.manifest.AppLinksManifestProducer;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.common.net.Uris;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.manifest.ApplicationStatus;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.webresource.api.WebResourceManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraManifestProducer
extends AppLinksManifestProducer {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public JiraManifestProducer(RequestFactory requestFactory, AppLinksManifestDownloader downloader, AppLinkPluginUtil appLinkPluginUtil, WebResourceManager webResourceManager) {
        super(requestFactory, downloader, webResourceManager, appLinkPluginUtil);
    }

    @Override
    protected TypeId getApplicationTypeId() {
        return JiraApplicationTypeImpl.TYPE_ID;
    }

    @Override
    protected String getApplicationName() {
        return "Jira";
    }

    @Override
    protected Set<Class<? extends AuthenticationProvider>> getSupportedInboundAuthenticationTypes() {
        return Set.of(BasicAuthenticationProvider.class, OAuthAuthenticationProvider.class, TwoLeggedOAuth2AuthenticationProvider.class, ThreeLeggedOAuth2AuthenticationProvider.class);
    }

    @Override
    protected Set<Class<? extends AuthenticationProvider>> getSupportedOutboundAuthenticationTypes() {
        return this.getSupportedInboundAuthenticationTypes();
    }

    @Override
    public ApplicationStatus getStatus(URI url) {
        try {
            URI manifestUri = Uris.concatenate(RestUtil.getBaseRestUri(url), "manifest");
            return super.getStatus(manifestUri);
        }
        catch (URISyntaxException e) {
            this.LOG.warn("Failed to create URI to Jira manifest: {}", (Object)url);
            return ApplicationStatus.UNAVAILABLE;
        }
    }
}

