/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.application.jira;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.application.BuiltinApplinksType;
import com.atlassian.applinks.application.HiResIconizedIdentifiableType;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.spi.application.NonAppLinksEntityType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import jakarta.annotation.Nonnull;
import java.net.URI;

public class JiraProjectEntityTypeImpl
extends HiResIconizedIdentifiableType
implements NonAppLinksEntityType,
JiraProjectEntityType,
BuiltinApplinksType {
    private static final TypeId TYPE_ID = new TypeId("jira.project");

    public JiraProjectEntityTypeImpl(AppLinkPluginUtil pluginUtil, WebResourceUrlProvider webResourceUrlProvider) {
        super(pluginUtil, webResourceUrlProvider);
    }

    @Nonnull
    public TypeId getId() {
        return TYPE_ID;
    }

    public String getI18nKey() {
        return "applinks.jira.project";
    }

    public String getPluralizedI18nKey() {
        return "applinks.jira.project.plural";
    }

    public String getShortenedI18nKey() {
        return "applinks.jira.project.short";
    }

    public Class<? extends ApplicationType> getApplicationType() {
        return JiraApplicationType.class;
    }

    public URI getDisplayUrl(ApplicationLink link, String project) {
        Assertions.isTrue((String)String.format("Application link %s is not of type %s", link.getId(), this.getApplicationType().getName()), (boolean)(link.getType() instanceof JiraApplicationType));
        return URIUtil.uncheckedConcatenate(link.getDisplayUrl(), "browse", project);
    }
}

