/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.oauth2;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.OAuth2ConnectionType;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.oauth2.ApplinkOAuth2Service;
import com.atlassian.applinks.application.generic.GenericApplicationTypeImpl;
import com.atlassian.applinks.application.generic.mobile.MobileAppLinkTypeResolver;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestFactoryFactory;
import com.atlassian.applinks.core.link.DefaultApplicationLink;
import com.atlassian.applinks.core.oauth2.ClientConfigStorageServiceFactory;
import com.atlassian.applinks.core.oauth2.MobileAppLinkTypeResolverServiceFactory;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crowd.embedded.api.OAuth2Method;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthMethod;
import com.atlassian.crowd.embedded.api.service.ServiceAccountAuthService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.client.api.storage.config.ClientConfigurationEntity;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.external.OAuth2ProviderService;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultApplinkOAuth2Service
implements ApplinkOAuth2Service {
    private final ClientConfigStorageServiceFactory clientConfigStorageServiceFactory;
    private final OAuth2ProviderService oAuth2ProviderService;
    private final MobileAppLinkTypeResolverServiceFactory mobileAppLinkTypeResolverServiceFactory;
    private final TypeAccessor typeAccessor;
    private final PropertyService propertyService;
    private final ApplicationLinkRequestFactoryFactory requestFactoryFactory;
    private final EventPublisher eventPublisher;
    private final MutatingApplicationLinkService applicationLinkService;
    private final ServiceAccountAuthService serviceAccountAuthService;

    @Autowired
    public DefaultApplinkOAuth2Service(ClientConfigStorageServiceFactory clientConfigStorageServiceFactory, OAuth2ProviderService oAuth2ProviderService, MobileAppLinkTypeResolverServiceFactory mobileAppLinkTypeResolverServiceFactory, TypeAccessor typeAccessor, PropertyService propertyService, ApplicationLinkRequestFactoryFactory requestFactoryFactory, EventPublisher eventPublisher, MutatingApplicationLinkService applicationLinkService, ServiceAccountAuthService serviceAccountAuthService) {
        this.clientConfigStorageServiceFactory = Objects.requireNonNull(clientConfigStorageServiceFactory);
        this.oAuth2ProviderService = Objects.requireNonNull(oAuth2ProviderService);
        this.typeAccessor = Objects.requireNonNull(typeAccessor);
        this.propertyService = Objects.requireNonNull(propertyService);
        this.requestFactoryFactory = Objects.requireNonNull(requestFactoryFactory);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.applicationLinkService = applicationLinkService;
        this.mobileAppLinkTypeResolverServiceFactory = mobileAppLinkTypeResolverServiceFactory;
        this.serviceAccountAuthService = serviceAccountAuthService;
    }

    public Iterable<ApplicationLink> getApplicationLinksForOAuth2Clients() {
        Set configs = StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).flatMap(link -> Stream.of(link.getAuthorizationCodeClientConfigurationId(), link.getClientCredentialsClientConfigurationId())).filter(id -> id != null && !id.isBlank()).collect(Collectors.toSet());
        return this.clientConfigStorageServiceFactory.get().map(service -> service.list().stream()).orElse(Stream.empty()).filter(configuration -> !configs.contains(configuration.getId())).map(this::createLinkFromClient).collect(Collectors.toList());
    }

    private ApplicationLink createLinkFromClient(ClientConfigurationEntity client) {
        ApplicationId id = new ApplicationId(client.getId());
        ApplicationType type = this.typeAccessor.loadApplicationType(GenericApplicationTypeImpl.TYPE_ID);
        ApplicationLinkProperties applicationLinkProperties = this.propertyService.getApplicationLinkProperties(Objects.requireNonNull(id));
        if (!client.getAuthorizationEndpoint().isEmpty()) {
            URI uri = URI.create(client.getAuthorizationEndpoint());
            String schemaAndHost = String.format("%s://%s", uri.getScheme(), uri.getHost());
            applicationLinkProperties.setDisplayUrl(schemaAndHost);
            applicationLinkProperties.setRpcUrl(schemaAndHost);
        }
        applicationLinkProperties.setClientId(client.getId());
        applicationLinkProperties.setName(client.getName());
        applicationLinkProperties.setOAuth2ConnectionType(OAuth2ConnectionType.OAUTH2_CLIENT);
        return new DefaultApplicationLink(id, type, applicationLinkProperties, this.requestFactoryFactory, this.eventPublisher);
    }

    public Iterable<ApplicationLink> getApplicationLinksForOAuth2Provider() {
        Set configs = StreamSupport.stream(this.applicationLinkService.getApplicationLinks().spliterator(), false).map(ReadOnlyApplicationLink::getClientId).filter(id -> id != null && !id.isBlank()).collect(Collectors.toSet());
        return this.oAuth2ProviderService.listClients().stream().filter(client -> !configs.contains(client.getId()) && !this.belongsToServiceAccount((Client)client)).map(this::createLinkFromProvider).collect(Collectors.toList());
    }

    private boolean belongsToServiceAccount(Client client) {
        return this.serviceAccountAuthService.findByAuthMethod((ServiceAccountAuthMethod)new OAuth2AuthMethod(client.getId())).isPresent();
    }

    private ApplicationLink createLinkFromProvider(Client client) {
        ApplicationId id = new ApplicationId(client.getId());
        ApplicationType type = this.loadApplicationType(id.get());
        ApplicationLinkProperties applicationLinkProperties = this.propertyService.getApplicationLinkProperties(Objects.requireNonNull(id));
        if (client.getRedirects() != null && !client.getRedirects().isEmpty()) {
            URI uri = URI.create((String)client.getRedirects().get(0));
            String schemaAndHost = String.format("%s://%s", uri.getScheme(), uri.getHost());
            applicationLinkProperties.setDisplayUrl(schemaAndHost);
            applicationLinkProperties.setRpcUrl(schemaAndHost);
        }
        applicationLinkProperties.setClientId(client.getId());
        applicationLinkProperties.setName(client.getName());
        applicationLinkProperties.setOAuth2ConnectionType(OAuth2ConnectionType.OAUTH2_PROVIDER);
        return new DefaultApplicationLink(id, type, applicationLinkProperties, this.requestFactoryFactory, this.eventPublisher);
    }

    private ApplicationType loadApplicationType(String clientId) {
        Optional<TypeId> resolvedTypeId;
        TypeId definedTypeId = GenericApplicationTypeImpl.TYPE_ID;
        Optional<MobileAppLinkTypeResolver> resolver = this.mobileAppLinkTypeResolverServiceFactory.get();
        if (resolver.isPresent() && (resolvedTypeId = resolver.get().resolve(clientId)).isPresent()) {
            definedTypeId = resolvedTypeId.get();
        }
        return this.typeAccessor.loadApplicationType(definedTypeId);
    }

    public record OAuth2AuthMethod(String authId) implements ServiceAccountAuthMethod
    {
        public String getAuthId() {
            return this.authId;
        }

        public AuthMethod getAuthType() {
            return new OAuth2Method();
        }
    }
}

