/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.plugin;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class AbstractAppLinksTypeModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    private Iterable<String> interfaces;

    public AbstractAppLinksTypeModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList(String.format("No %s class specified", ApplicationType.class.getSimpleName())));
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        Objects.requireNonNull(plugin, "plugin can't be null");
        Objects.requireNonNull(element, "element can't be null");
        super.init(plugin, element);
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Element child : element.elements("interface")) {
            interfaces.add(child.getTextTrim());
        }
        if (element.attributeValue("interface") != null) {
            interfaces.add(element.attributeValue("interface"));
        }
        this.interfaces = interfaces;
    }

    public Iterable<String> getInterfaces() {
        return this.interfaces;
    }

    public T getModule() {
        return (T)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }
}

