/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.plugin;

import com.atlassian.applinks.core.plugin.DescriptorWeightAttributeParser;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

public class AuthenticationProviderModuleDescriptor
extends AbstractModuleDescriptor<AuthenticationProviderPluginModule> {
    public static Comparator<AuthenticationProviderModuleDescriptor> BY_WEIGHT = Comparator.comparingInt(AuthenticationProviderModuleDescriptor::getWeight);
    private int weight;

    public AuthenticationProviderModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        Objects.requireNonNull(plugin, "plugin can't be null");
        Objects.requireNonNull(element, "element can't be null");
        super.init(plugin, element);
        this.weight = DescriptorWeightAttributeParser.getWeight(element);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException("AuthenticationProviderModuleDescriptor validation errors", Collections.singletonList("missing class attribute"));
        }
        if (element.attributeValue("i18n-name-key") == null) {
            throw new ValidationException("ApplicationTypeModuleDescriptor validation errors", Collections.singletonList("missing i18n-name-key attribute"));
        }
    }

    public AuthenticationProviderPluginModule getModule() {
        return (AuthenticationProviderPluginModule)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public int getWeight() {
        return this.weight;
    }
}

