/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.plugin;

import com.atlassian.applinks.core.plugin.DescriptorWeightAttributeParser;
import com.atlassian.applinks.internal.uniconn.entitlements.DataExportEntitlement;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DataExportEntitlementModuleDescriptor
extends AbstractModuleDescriptor<Set<DataExportEntitlement>> {
    public static final String XML_ELEMENT_NAME = "data-export-entitlement";
    private Set<DataExportEntitlement> dataExportEntitlementsSet;
    private int weight;

    public DataExportEntitlementModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = DescriptorWeightAttributeParser.getWeight(element);
        List entitlements = element.elements("entitlement");
        if (entitlements == null) {
            throw new PluginParseException("Missing entitlement element");
        }
        this.dataExportEntitlementsSet = entitlements.stream().map(this::parseEntitlement).collect(Collectors.toSet());
    }

    private DataExportEntitlement parseEntitlement(Element entitlement) throws PluginParseException {
        String entitlementKey = entitlement.attributeValue("entitlement-key");
        String titleI18nKey = entitlement.attributeValue("title-i18n-key");
        String descriptionPrefix = entitlement.attributeValue("description-prefix");
        if (entitlementKey == null) {
            throw new PluginParseException("Missing entitlement-key attribute");
        }
        if (titleI18nKey == null) {
            throw new PluginParseException("Missing title-i18n-key attribute");
        }
        return new DataExportEntitlement(entitlementKey, titleI18nKey, descriptionPrefix, this.weight, this.getPlugin().getKey());
    }

    public Set<DataExportEntitlement> getModule() {
        return this.dataExportEntitlementsSet;
    }

    public String getDisplayName() {
        return "Data Export Entitlements";
    }

    public int getWeight() {
        return this.weight;
    }
}

