/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.plugins.rest.api.model.Link;
import com.atlassian.plugins.rest.api.util.RestUrlBuilder;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import java.net.URI;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource {
    protected final RestUrlBuilder restUrlBuilder;
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected final InternalTypeAccessor typeAccessor;
    protected final RequestFactory<Request<Request<?, Response>, Response>> requestFactory;
    protected final MutatingApplicationLinkService applicationLinkService;

    public AbstractResource(RestUrlBuilder restUrlBuilder, InternalTypeAccessor typeAccessor, RequestFactory<Request<Request<?, Response>, Response>> requestFactory, MutatingApplicationLinkService applicationLinkService) {
        this.restUrlBuilder = restUrlBuilder;
        this.typeAccessor = typeAccessor;
        this.requestFactory = requestFactory;
        this.applicationLinkService = applicationLinkService;
    }

    protected final <T> URI getUrlFor(URI baseUri, Class<T> resourceClass, Consumer<T> consumer) {
        return this.restUrlBuilder.getUrlFor(baseUri, resourceClass, consumer);
    }

    protected ApplicationLinkEntity toApplicationLinkEntity(ApplicationLink appLink) {
        return new ApplicationLinkEntity(appLink, this.createSelfLinkFor(appLink.getId()));
    }

    protected Link createSelfLinkFor(ApplicationId appID) {
        return Link.self((URI)this.applicationLinkService.createSelfLinkFor(appID));
    }
}

