/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.AppLinkPluginUtil;
import com.atlassian.applinks.core.rest.context.UriInfoFilterBinding;
import com.atlassian.applinks.core.rest.model.ManifestEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.rest.RestUrlBuilder;
import com.atlassian.applinks.internal.rest.interceptor.CorsFilterBinding;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderFilterBinding;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.ApplicationProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api
@Path(value="manifest")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@UriInfoFilterBinding
@NoCacheHeaderFilterBinding
@CorsFilterBinding
@UnrestrictedAccess
public class ManifestResource {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestResource.class);
    public static final String CONTEXT = "manifest";
    private final InternalHostApplication internalHostApplication;
    private final ManifestRetriever manifestRetriever;
    private final ApplicationLinkService applicationLinkService;
    private final AppLinkPluginUtil pluginUtil;
    private final ApplicationProperties applicationProperties;

    @Nonnull
    public static RestUrlBuilder manifestUrl() {
        return new RestUrlBuilder().addPath(CONTEXT);
    }

    @Inject
    public ManifestResource(InternalHostApplication internalHostApplication, ManifestRetriever manifestRetriever, ApplicationLinkService applicationLinkService, ApplicationProperties applicationProperties, AppLinkPluginUtil pluginUtil) {
        this.internalHostApplication = internalHostApplication;
        this.manifestRetriever = manifestRetriever;
        this.applicationLinkService = applicationLinkService;
        this.applicationProperties = applicationProperties;
        this.pluginUtil = pluginUtil;
    }

    @GET
    @ApiOperation(value="Returns the manifest for this application", response=ManifestEntity.class)
    @ApiResponse(code=200, message="Successful")
    public Response getManifest() {
        return RestUtil.ok(new ManifestEntity(this.internalHostApplication, this.applicationProperties, this.pluginUtil));
    }

    @GET
    @ApiOperation(value="Returns the manifest for an applink with a given ID", response=ManifestEntity.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Manifest not found on remote host"), @ApiResponse(code=400, message="No application link exists with provided ID"), @ApiResponse(code=200, message="Successful")})
    @Path(value="{id}")
    public Response getManifestFor(@PathParam(value="id") String id) {
        Manifest manifest;
        ApplicationId applicationId = new ApplicationId(id);
        ApplicationLink applicationLink = null;
        try {
            applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
        }
        catch (TypeNotInstalledException typeNotInstalledException) {
            // empty catch block
        }
        if (applicationLink == null) {
            return RestUtil.badRequest(String.format("No application link with id %s", applicationId));
        }
        try {
            manifest = this.manifestRetriever.getManifest(applicationLink.getRpcUrl(), applicationLink.getType());
        }
        catch (ManifestNotFoundException e) {
            return RestUtil.notFound(String.format("Couldn't retrieve manifest for link with id %s", applicationId));
        }
        return this.response(manifest);
    }

    private Response response(Manifest manifest) {
        return RestUtil.ok(new ManifestEntity(manifest));
    }
}

